/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExternalizeTextDialog
extends Dialog {
    private String oldValue;
    private String textValue;
    private Text text;
    private boolean canExternalize;
    private boolean isExternalized;
    private Button externalizeButton;
    private Button updateButton;
    private String propertyName;

    public ExternalizeTextDialog(Shell parentShell, String oldValue, boolean canExternalize, String propertyName) {
        super(parentShell);
        this.oldValue = oldValue;
        this.canExternalize = canExternalize;
        this.isExternalized = !canExternalize;
        this.propertyName = propertyName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Set " + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1) + " Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)dialogArea.getLayout();
        layout.numColumns = 3;
        Label label = new Label(dialogArea, 0);
        label.setText(this.propertyName);
        this.text = new Text(dialogArea, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.text.setText(this.oldValue == null ? "" : this.oldValue);
        this.text.setLayoutData((Object)gridData);
        this.textValue = this.text.getText();
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalizeTextDialog.this.textValue = ExternalizeTextDialog.this.text.getText();
                if (!ExternalizeTextDialog.this.textValue.equals(ExternalizeTextDialog.this.oldValue)) {
                    ExternalizeTextDialog.this.updateButton.setEnabled(true);
                    ExternalizeTextDialog.this.canExternalize = false;
                    ExternalizeTextDialog.this.externalizeButton.setEnabled(ExternalizeTextDialog.this.canExternalize);
                } else if (!ExternalizeTextDialog.this.isExternalized) {
                    ExternalizeTextDialog.this.updateButton.setEnabled(false);
                    ExternalizeTextDialog.this.canExternalize = true;
                    ExternalizeTextDialog.this.externalizeButton.setEnabled(ExternalizeTextDialog.this.canExternalize);
                } else {
                    ExternalizeTextDialog.this.updateButton.setEnabled(false);
                }
            }
        });
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, "Externalize Value", false);
        this.externalizeButton = this.getButton(2);
        this.externalizeButton.setEnabled(!this.isExternalized);
        this.createButton(parent, 0, "Update value", false);
        this.updateButton = this.getButton(0);
        this.updateButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (2 == buttonId) {
            this.externalizePressed();
        }
    }

    protected void externalizePressed() {
        this.setReturnCode(2);
        this.close();
    }

    public String getTextValue() {
        return this.textValue;
    }
}

