/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.databinding.BindingMode;
import org.eclipse.xwt.internal.core.UpdateSourceTrigger;
import org.eclipse.xwt.tools.ui.designer.databinding.IBindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.IGroup;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public class OptionsGroup
implements IGroup {
    private ComboViewer modeComboViewer;
    private ComboViewer triggersComboViewer;
    private Text converterText;
    private BindingMode bindingMode;
    private UpdateSourceTrigger updateSourceTrigger;

    public ExpandableComposite createGroup(final Composite parent, int style) {
        FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
        final ExpandableComposite result = formToolkit.createExpandableComposite(parent, 66);
        result.setText("Options");
        Composite cilent = formToolkit.createComposite((Composite)result);
        cilent.setLayout((Layout)new GridLayout(3, false));
        result.setClient((Control)cilent);
        result.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                parent.layout(new Control[]{result});
            }
        });
        formToolkit.createLabel(cilent, "BindingMode:");
        Combo modeCombo = new Combo(cilent, 12);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        modeCombo.setLayoutData((Object)layoutData);
        formToolkit.adapt((Control)modeCombo, true, true);
        this.modeComboViewer = this.createComboViewr(modeCombo);
        this.modeComboViewer.setInput((Object)BindingMode.values());
        this.modeComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OptionsGroup.this.bindingMode = (BindingMode)selection.getFirstElement();
            }
        });
        formToolkit.createLabel(cilent, "UpdateSourceTrigger:");
        Combo triggerCombo = new Combo(cilent, 12);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        triggerCombo.setLayoutData((Object)layoutData);
        formToolkit.adapt((Control)triggerCombo, true, true);
        this.triggersComboViewer = this.createComboViewr(triggerCombo);
        this.triggersComboViewer.setInput((Object)UpdateSourceTrigger.values());
        this.triggersComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OptionsGroup.this.updateSourceTrigger = (UpdateSourceTrigger)selection.getFirstElement();
            }
        });
        formToolkit.createLabel(cilent, "Converter:");
        this.converterText = formToolkit.createText(cilent, "", 2048);
        layoutData = new GridData(768);
        this.converterText.setLayoutData((Object)layoutData);
        formToolkit.adapt((Control)this.converterText, true, true);
        Button button = formToolkit.createButton(cilent, "", 0);
        button.setImage(ImageShop.get("/icons/full/tools/observe/custom.png"));
        button.setToolTipText("Choose a converter.");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                OptionsGroup.this.chooseConverter();
            }
        });
        return result;
    }

    private ComboViewer createComboViewr(Combo combo) {
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Object[]) {
                    return (Object[])inputElement;
                }
                return new Object[0];
            }
        });
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        return comboViewer;
    }

    protected void chooseConverter() {
    }

    public BindingMode getBindingMode() {
        if (this.bindingMode == null) {
            this.bindingMode = BindingMode.TwoWay;
        }
        return this.bindingMode;
    }

    public UpdateSourceTrigger getUpdateSourceTrigger() {
        if (this.updateSourceTrigger == null) {
            this.updateSourceTrigger = UpdateSourceTrigger.Default;
        }
        return this.updateSourceTrigger;
    }

    public Class<?> getConverter() {
        String className = this.converterText.getText();
        if (className != null && !className.equals("")) {
            return XWT.getLoadingContext().loadClass(className);
        }
        return null;
    }

    @Override
    public void setInput(Object input) {
        String converter = null;
        if (input instanceof IBindingInfo) {
            this.bindingMode = ((IBindingInfo)input).getBindingMode();
            this.updateSourceTrigger = ((IBindingInfo)input).getTriggerMode();
            converter = ((IBindingInfo)input).getConverter();
        }
        if (this.modeComboViewer != null) {
            this.modeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getBindingMode()));
        }
        if (this.updateSourceTrigger != null) {
            this.triggersComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getUpdateSourceTrigger()));
        }
        if (converter == null) {
            converter = "";
        }
        this.converterText.setText(converter);
    }
}

