/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.util.swt;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTUtil {
    public static final boolean IsWindows = "win32".equals(SWT.getPlatform());
    public static final boolean IsMotif = "motif".equals(SWT.getPlatform());
    public static final boolean IsGTK = "gtk".equals(SWT.getPlatform());
    public static final boolean IsPhoton = "photon".equals(SWT.getPlatform());
    public static final boolean IsCarbon = "carbon".equals(SWT.getPlatform());
    public static final boolean IsCocoa = "cocoa".equals(SWT.getPlatform());

    public static void printStyle(int style, Class<? extends Widget> clazz, Appendable appendable) {
        try {
            appendable.append("[");
            boolean first = true;
            int styleBit = 0;
            int styleMask = 1;
            while (styleBit < 32) {
                if ((style & styleMask) != 0) {
                    if (!first) {
                        appendable.append(',');
                    } else {
                        first = false;
                    }
                    appendable.append(SWTUtil.toStringStyleBit(styleMask, clazz));
                }
                ++styleBit;
                styleMask <<= 1;
            }
            appendable.append(']');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toStringStyle(int style, Class<? extends Widget> clazz) {
        StringBuilder builder = new StringBuilder();
        SWTUtil.printStyle(style, clazz, builder);
        return builder.toString();
    }

    public static String toStringStyleBit(int style, Class<? extends Widget> clazz) {
        switch (style) {
            case 2: {
                if (Menu.class.isAssignableFrom(clazz)) {
                    return "bar";
                }
                if (Label.class.isAssignableFrom(clazz) || MenuItem.class.isAssignableFrom(clazz) || ToolItem.class.isAssignableFrom(clazz)) {
                    return "separator";
                }
                if (Button.class.isAssignableFrom(clazz)) {
                    return "toggle";
                }
                if (Text.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz)) {
                    return "multi";
                }
                if (!ProgressBar.class.isAssignableFrom(clazz)) break;
                return "indeterminate";
            }
            case 4: {
                if (Menu.class.isAssignableFrom(clazz) || ToolItem.class.isAssignableFrom(clazz) || CoolItem.class.isAssignableFrom(clazz) || Combo.class.isAssignableFrom(clazz)) {
                    return "drop-down";
                }
                if (Button.class.isAssignableFrom(clazz)) {
                    return "arrow";
                }
                if (Text.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz) || Table.class.isAssignableFrom(clazz) || Tree.class.isAssignableFrom(clazz)) {
                    return "single";
                }
                if (Label.class.isAssignableFrom(clazz) || Group.class.isAssignableFrom(clazz)) {
                    return "shadow-in";
                }
                if (!Decorations.class.isAssignableFrom(clazz)) break;
                return "tool";
            }
            case 8: {
                if (Menu.class.isAssignableFrom(clazz)) {
                    return "pop-up";
                }
                if (Button.class.isAssignableFrom(clazz) || MenuItem.class.isAssignableFrom(clazz) || ToolItem.class.isAssignableFrom(clazz)) {
                    return "push";
                }
                if (Combo.class.isAssignableFrom(clazz) || Text.class.isAssignableFrom(clazz)) {
                    return "read-only";
                }
                if (Label.class.isAssignableFrom(clazz) || Group.class.isAssignableFrom(clazz) || ToolBar.class.isAssignableFrom(clazz)) {
                    return "shadow-out";
                }
                if (!Decorations.class.isAssignableFrom(clazz)) break;
                return "no-trip";
            }
            case 16: {
                if (Button.class.isAssignableFrom(clazz) || MenuItem.class.isAssignableFrom(clazz) || ToolItem.class.isAssignableFrom(clazz)) {
                    return "radio";
                }
                if (Group.class.isAssignableFrom(clazz)) {
                    return "shadow-etched-in";
                }
                if (!Decorations.class.isAssignableFrom(clazz) && !Tracker.class.isAssignableFrom(clazz)) break;
                return "resize";
            }
            case 32: {
                if (Button.class.isAssignableFrom(clazz) || MenuItem.class.isAssignableFrom(clazz) || ToolItem.class.isAssignableFrom(clazz) || Table.class.isAssignableFrom(clazz) || Tree.class.isAssignableFrom(clazz)) {
                    return "check";
                }
                if (Label.class.isAssignableFrom(clazz) || Group.class.isAssignableFrom(clazz)) {
                    return "shadow-none";
                }
                if (!Decorations.class.isAssignableFrom(clazz)) break;
                return "title";
            }
            case 64: {
                if (MenuItem.class.isAssignableFrom(clazz)) {
                    return "cascade";
                }
                if (Label.class.isAssignableFrom(clazz) || Text.class.isAssignableFrom(clazz) || ToolBar.class.isAssignableFrom(clazz) || Spinner.class.isAssignableFrom(clazz)) {
                    return "wrap";
                }
                if (Combo.class.isAssignableFrom(clazz)) {
                    return "simple";
                }
                if (Group.class.isAssignableFrom(clazz)) {
                    return "shadow-etched-out";
                }
                if (!Decorations.class.isAssignableFrom(clazz)) break;
                return "close";
            }
            case 128: {
                if (Decorations.class.isAssignableFrom(clazz)) {
                    return "min";
                }
                if (!Button.class.isAssignableFrom(clazz) && !Tracker.class.isAssignableFrom(clazz)) break;
                return "up";
            }
            case 256: {
                if (Scrollable.class.isAssignableFrom(clazz)) {
                    return "h-scroll";
                }
                if (!Label.class.isAssignableFrom(clazz) && !ProgressBar.class.isAssignableFrom(clazz) && !Sash.class.isAssignableFrom(clazz) && !Scale.class.isAssignableFrom(clazz) && !ScrollBar.class.isAssignableFrom(clazz) && !Slider.class.isAssignableFrom(clazz) && !ToolBar.class.isAssignableFrom(clazz)) break;
                return "horizontal";
            }
            case 512: {
                if (Scrollable.class.isAssignableFrom(clazz)) {
                    return "v-scroll";
                }
                if (!Label.class.isAssignableFrom(clazz) && !ProgressBar.class.isAssignableFrom(clazz) && !Sash.class.isAssignableFrom(clazz) && !Scale.class.isAssignableFrom(clazz) && !ScrollBar.class.isAssignableFrom(clazz) && !Slider.class.isAssignableFrom(clazz) && !ToolBar.class.isAssignableFrom(clazz) && !CoolBar.class.isAssignableFrom(clazz)) break;
                return "vertical";
            }
            case 1024: {
                if (Decorations.class.isAssignableFrom(clazz)) {
                    return "max";
                }
                if (!Button.class.isAssignableFrom(clazz) && !Tracker.class.isAssignableFrom(clazz)) break;
                return "down";
            }
            case 2048: {
                if (!Control.class.isAssignableFrom(clazz)) break;
                return "border";
            }
            case 4096: {
                if (!Control.class.isAssignableFrom(clazz)) break;
                return "clip-children";
            }
            case 8192: {
                if (!Control.class.isAssignableFrom(clazz)) break;
                return "clip-siblings";
            }
            case 16384: {
                if (Shell.class.isAssignableFrom(clazz)) {
                    return "on-top";
                }
                if (!Button.class.isAssignableFrom(clazz) && !Label.class.isAssignableFrom(clazz) && !TableColumn.class.isAssignableFrom(clazz) && !Tracker.class.isAssignableFrom(clazz)) break;
                return "lead";
            }
            case 32768: {
                if (Shell.class.isAssignableFrom(clazz)) {
                    return "primary-modal";
                }
                if (!Table.class.isAssignableFrom(clazz)) break;
                return "hide-selection";
            }
            case 65536: {
                if (Shell.class.isAssignableFrom(clazz)) {
                    return "application-modal";
                }
                if (StyledText.class.isAssignableFrom(clazz) || Table.class.isAssignableFrom(clazz) || Tree.class.isAssignableFrom(clazz)) {
                    return "full-selection";
                }
                if (!ProgressBar.class.isAssignableFrom(clazz) && !Sash.class.isAssignableFrom(clazz)) break;
                return "smooth";
            }
            case 131072: {
                if (Shell.class.isAssignableFrom(clazz)) {
                    return "system-modal";
                }
                if (!Button.class.isAssignableFrom(clazz) && !Label.class.isAssignableFrom(clazz) && !TableColumn.class.isAssignableFrom(clazz) && !Tracker.class.isAssignableFrom(clazz)) break;
                return "trail";
            }
            case 262144: {
                if (!Composite.class.isAssignableFrom(clazz)) break;
                return "no-background";
            }
            case 524288: {
                if (!Composite.class.isAssignableFrom(clazz)) break;
                return "no-focus";
            }
            case 0x100000: {
                if (!Composite.class.isAssignableFrom(clazz)) break;
                return "no-redraw-resize";
            }
            case 0x200000: {
                if (!Composite.class.isAssignableFrom(clazz)) break;
                return "no-merge-paints";
            }
            case 0x400000: {
                if (Text.class.isAssignableFrom(clazz)) {
                    return "password";
                }
                if (!Composite.class.isAssignableFrom(clazz)) break;
                return "no-radio-group";
            }
            case 0x800000: {
                if (!Button.class.isAssignableFrom(clazz) && !ToolBar.class.isAssignableFrom(clazz)) break;
                return "flat";
            }
            case 0x1000000: {
                if (Composite.class.isAssignableFrom(clazz)) {
                    return "embedded";
                }
                if (!Button.class.isAssignableFrom(clazz) && !Label.class.isAssignableFrom(clazz) && !TableColumn.class.isAssignableFrom(clazz)) break;
                return "center";
            }
            case 0x2000000: {
                break;
            }
            case 0x4000000: {
                if (!Control.class.isAssignableFrom(clazz) && !Menu.class.isAssignableFrom(clazz)) break;
                return "right-to-left";
            }
            case 0x8000000: {
                if (!Control.class.isAssignableFrom(clazz) && !Menu.class.isAssignableFrom(clazz)) break;
                return "mirrored";
            }
            case 0x10000000: {
                if (!Table.class.isAssignableFrom(clazz) && !Tree.class.isAssignableFrom(clazz)) break;
                return "virtual";
            }
            case 0x20000000: {
                if (!Control.class.isAssignableFrom(clazz)) break;
                return "double-buffered";
            }
        }
        return String.format("%08x", style);
    }
}

