/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xwt.vex.Activator;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VEXSharedImages {
    public static final String[] IMAGE_SUFFIX = new String[]{".png", ".gif"};
    public static final IPath ICONS_PATH = new Path("icons");
    private static ImageRegistry fgImageRegistry;

    public static Image get(String key) {
        Image image = VEXSharedImages.getImageRegistry().get(key);
        if (image == null) {
            image = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor des = VEXSharedImages.getImageRegistry().getDescriptor(key);
        if (des == null) {
            des = ImageDescriptor.getMissingImageDescriptor();
        }
        return des;
    }

    private static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            VEXSharedImages.loadImages();
        }
        return fgImageRegistry;
    }

    private static void loadImages() {
        Bundle bundle = Activator.getDefault().getBundle();
        String prefix = "platform:/plugin/" + bundle.getSymbolicName() + "/" + ICONS_PATH + "/";
        try {
            URL url = FileLocator.find((Bundle)bundle, (IPath)ICONS_PATH, null);
            URL iconUrl = FileLocator.toFileURL((URL)url);
            String iconUrlString = iconUrl.toString();
            File iconFolder = new File(new Path(iconUrl.getPath()).toOSString());
            LinkedList<File> images = new LinkedList<File>();
            VEXSharedImages.retreiveImages(iconFolder, images);
            for (File file : images) {
                URL fileURL = file.toURI().toURL();
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)fileURL);
                String fileURLString = fileURL.toString();
                if (!fileURLString.startsWith(iconUrlString)) continue;
                String suffix = fileURLString.substring(iconUrlString.length());
                String key = String.valueOf(prefix) + suffix;
                fgImageRegistry.put(key, descriptor);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void retreiveImages(File icon, List<File> images) {
        if (icon.isDirectory()) {
            File[] fileArray = icon.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                VEXSharedImages.retreiveImages(file, images);
                ++n2;
            }
        } else {
            String name = icon.getName();
            if (name.endsWith(IMAGE_SUFFIX[0]) || name.endsWith(IMAGE_SUFFIX[1])) {
                images.add(icon);
            }
        }
    }

    public static void initialize() {
        VEXSharedImages.getImageRegistry();
    }
}

