/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.vex;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.xwt.vex.VEXEditor;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCodeSynchronizer
implements VEXCodeSynchronizer {
    private final Map<Node, String> node2name = new HashMap<Node, String>();
    private String oldAttrValue;
    private VEXEditor editor;
    private String cacheContent = "";

    public AbstractCodeSynchronizer(VEXEditor editor) {
        this.editor = editor;
    }

    public String getOldAttrValue() {
        return this.oldAttrValue;
    }

    public void setOldAttrValue(String oldAttrValue) {
        this.oldAttrValue = oldAttrValue;
    }

    public String getCacheContent() {
        return this.cacheContent;
    }

    public void setCacheContent(String cacheContent) {
        this.cacheContent = cacheContent;
    }

    public Map<Node, String> getNode2name() {
        return this.node2name;
    }

    public VEXEditor getEditor() {
        return this.editor;
    }

    @Override
    public void add(final IDOMNode node, final String name) {
        if (node != null && name != null && !name.equals("")) {
            String oldName = this.node2name.get(node);
            if (oldName != null) {
                if (oldName.equals(name)) {
                    return;
                }
                this.remove(node);
                this.add(node, name);
            }
            this.node2name.put((Node)node, name);
            Display display = Display.getDefault();
            if (display != null) {
                display.syncExec(new Runnable(){

                    public void run() {
                        String fullTypeName = AbstractCodeSynchronizer.this.getFullTypeName(node);
                        if (fullTypeName == null) {
                            return;
                        }
                        AbstractCodeSynchronizer.this.generateFields(fullTypeName, name);
                        AbstractCodeSynchronizer.this.buildInitialization();
                    }
                });
            }
        }
    }

    protected abstract String getFullTypeName(IDOMNode var1);

    protected void updateCodeManager() {
        StructuredTextViewer textViewer = this.editor.getTextEditor().getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node root = (Node)treeNode;
        while (root != null && root.getParentNode() != null && !(root.getParentNode() instanceof Document)) {
            root = root.getParentNode();
        }
        this.update((IDOMNode)root);
    }

    @Override
    public void update(IDOMNode parentNode) {
        if (parentNode.getNodeType() == 3) {
            return;
        }
        if (!this.editor.getContext().hasType((Node)parentNode)) {
            return;
        }
        boolean findNameAttr = false;
        NamedNodeMap attributes = parentNode.getAttributes();
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            Node item = attributes.item(i);
            String nodeName = item.getNodeName();
            if ("Name".equals(nodeName)) {
                findNameAttr = true;
                if (this.oldAttrValue != null) {
                    this.remove(parentNode);
                }
                this.add(parentNode, item.getNodeValue());
            }
            ++i;
        }
        if (!findNameAttr) {
            this.remove(parentNode);
        }
        NodeList childNodes = parentNode.getChildNodes();
        int len = childNodes.getLength();
        int i2 = 0;
        while (i2 < len) {
            Node item = childNodes.item(i2);
            this.update((IDOMNode)item);
            ++i2;
        }
    }

    @Override
    public boolean codeAboutToBeChanged() {
        StructuredTextViewer textViewer = this.editor.getTextEditor().getTextViewer();
        int offset = textViewer.getTextWidget().getCaretOffset();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)offset);
        Node node = (Node)treeNode;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode xmlnode = (IDOMNode)node;
        if (xmlnode != null && this.editor.getContext().hasType((Node)xmlnode)) {
            NamedNodeMap nodeMap = xmlnode.getAttributes();
            int i = nodeMap.getLength() - 1;
            while (i >= 0) {
                IDOMAttr attrNode = (IDOMAttr)nodeMap.item(i);
                String attrName = attrNode.getName();
                String attrValue = attrNode.getValue();
                int startOffset = attrNode.getStartOffset();
                int endOffset = startOffset + attrName.length() + attrValue.length() + 3;
                if (offset >= startOffset && offset < endOffset) {
                    this.oldAttrValue = attrValue;
                    return true;
                }
                --i;
            }
        }
        this.oldAttrValue = null;
        return false;
    }

    protected String updateCacheContent(IDocument newInput) {
        StringBuffer buffer = new StringBuffer();
        String content = newInput.get();
        char[] cArray = content.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                buffer.append(c);
            }
            ++n2;
        }
        return buffer.toString();
    }

    protected boolean checkContent(String content) {
        StringBuffer buffer = new StringBuffer();
        char[] cArray = content.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isWhitespace(c)) {
                buffer.append(c);
            }
            ++n2;
        }
        String value = buffer.toString();
        if (value.equals(this.cacheContent)) {
            return true;
        }
        this.cacheContent = value;
        return false;
    }

    protected String resolveHostClass(Node node) {
        return null;
    }

    protected IProgressMonitor getProgressMonitor() {
        ProgressManager progresManager = (ProgressManager)this.editor.getTextEditor().getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        IProgressMonitor monitor = progresManager.getDefaultMonitor();
        return monitor;
    }

    protected IProject getProject() {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }
}

