/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties.editors;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.tools.ui.designer.XWTDesignerPlugin;
import org.eclipse.xwt.tools.ui.designer.dialogs.ExternalizeTextDialog;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.properties.PropertyContext;
import org.eclipse.xwt.tools.ui.designer.properties.editors.AbstractCellEditor;
import org.eclipse.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.xwt.tools.ui.designer.wizards.ExternalizeStringsWizard;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.xwt.tools.ui.designer.wizards.models.TextValueModel;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class TextCellEditor
extends AbstractCellEditor {
    private boolean canExternalize;
    private PropertyContext fContext;
    private IProperty property;
    private XamlAttribute attribute;

    public TextCellEditor(PropertyContext fContext, IProperty property, Composite parent) {
        super(parent);
        this.fContext = fContext;
        this.property = property;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        XWTDesigner designer = XWTDesignerPlugin.getDefault().getActiveDesigner();
        this.attribute = this.createAttribute(this.fContext.getNode());
        String oldValue = (String)this.getValue();
        String value = this.attribute.getValue();
        if (designer != null) {
            this.canExternalize = value != null;
            ExternalizeTextDialog dialog = new ExternalizeTextDialog(cellEditorWindow.getShell(), oldValue, this.canExternalize, this.property.getName());
            int returnValue = dialog.open();
            if (returnValue == 0) {
                return dialog.getTextValue();
            }
            if (2 == returnValue) {
                boolean isOK = this.externalizeText(dialog.getTextValue());
                if (isOK) {
                    return dialog.getTextValue();
                }
                return oldValue;
            }
        }
        return null;
    }

    protected XamlAttribute createAttribute(XamlNode parent) {
        String attrName = this.property.getName();
        if (attrName == null) {
            throw new NullPointerException("Attribute name is null");
        }
        XamlAttribute attr = XWTModelUtil.getAdaptableAttribute(parent, attrName, "http://www.eclipse.org/xwt/presentation");
        if (attr == null) {
            attr = XamlFactory.eINSTANCE.createAttribute(attrName, "http://www.eclipse.org/xwt/presentation");
        }
        return attr;
    }

    private boolean externalizeText(String textValue) {
        XWTDesigner designer = XWTDesignerPlugin.getDefault().getActiveDesigner();
        String oldValue = this.attribute.getValue();
        TextValueModel textValueEntrys = new TextValueModel();
        textValueEntrys.add(new TextValueEntry(textValue, "0"));
        ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(textValueEntrys, designer);
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int returnValue = dialog.open();
        if (1 == returnValue) {
            this.attribute.setValue(oldValue);
            return false;
        }
        return true;
    }
}

