/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.properties.PropertyContext;
import org.eclipse.xwt.tools.ui.designer.properties.XWTPropertySource;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class XWTPropertySourceProvider
implements IPropertySourceProvider {
    private EditDomain editDomain;
    private Map<Object, IPropertySource> sourceMap = new HashMap<Object, IPropertySource>();
    private Adapter refresher = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            XWTPropertySourceProvider.this.refresh();
        }
    };
    private PropertiesRefreshJob fPropertiesRefreshJob;
    private PropertySheetPage propertyPage;

    public XWTPropertySourceProvider(EditDomain editDomain, PropertySheetPage propertyPage) {
        this.editDomain = editDomain;
        this.propertyPage = propertyPage;
    }

    private void refresh() {
        if (this.propertyPage != null) {
            this.getPropertiesRefreshJob().doRefresh();
        }
    }

    private PropertiesRefreshJob getPropertiesRefreshJob() {
        if (this.fPropertiesRefreshJob == null) {
            this.fPropertiesRefreshJob = new PropertiesRefreshJob();
        }
        return this.fPropertiesRefreshJob;
    }

    public IPropertySource getPropertySource(Object object) {
        IPropertySource propertySource = this.sourceMap.get(object);
        if (propertySource == null) {
            propertySource = this.createPropertySource(object);
            this.sourceMap.put(object, propertySource);
        }
        return propertySource;
    }

    private IPropertySource createPropertySource(Object object) {
        PropertyContext context = null;
        if (object instanceof EditPart) {
            EditPart editPart = (EditPart)object;
            context = new PropertyContext(editPart, null);
            if (this.editDomain == null) {
                this.editDomain = (EditDomain)((EditPart)object).getViewer().getEditDomain();
            }
            context.setEditDomain(this.editDomain);
        } else if (object instanceof PropertyContext) {
            context = (PropertyContext)object;
        }
        if (context != null) {
            final XamlNode model = context.getNode();
            if (!model.eAdapters().contains((Object)this.refresher)) {
                model.eAdapters().add((Object)this.refresher);
            }
            return new XWTPropertySource(context){

                public void setPropertyValue(Object id, Object value) {
                    model.eAdapters().remove((Object)XWTPropertySourceProvider.this.refresher);
                    super.setPropertyValue(id, value);
                    model.eAdapters().add((Object)XWTPropertySourceProvider.this.refresher);
                }
            };
        }
        return null;
    }

    private class PropertiesRefreshJob
    extends UIJob {
        public static final int UPDATE_DELAY = 200;

        public PropertiesRefreshJob() {
            super("Refresh Properties Page.");
            this.setSystem(true);
            this.setPriority(20);
        }

        public void doRefresh() {
            this.schedule(200L);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (XWTPropertySourceProvider.this.propertyPage != null && XWTPropertySourceProvider.this.propertyPage.getControl() != null && !XWTPropertySourceProvider.this.propertyPage.getControl().isDisposed()) {
                XWTPropertySourceProvider.this.propertyPage.refresh();
            }
            return Status.OK_STATUS;
        }
    }
}

