/*
 * Decompiled with CFR 0.152.
 */
package test.swt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineScenarioCallback;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.swt.SWTRepaintTimeline;

public class Fireworks
extends Canvas {
    private Set<VolleyExplosion> volleys;
    private Map<VolleyExplosion, TimelineScenario> volleyScenarios;
    private boolean firstVolleyInitiated;

    public Fireworks(Composite parent) {
        super(parent, 0x20000000);
        this.addPaintListener(new PaintListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setBackground(e.display.getSystemColor(2));
                gc.fillRectangle(e.x, e.y, e.width, e.height);
                Set set = Fireworks.this.volleys;
                synchronized (set) {
                    for (VolleyExplosion exp : Fireworks.this.volleys) {
                        exp.paint(gc);
                    }
                }
            }
        });
        SWTRepaintTimeline repaint = new SWTRepaintTimeline((Control)this);
        repaint.playLoop(Timeline.RepeatBehavior.LOOP);
        this.volleys = new HashSet<VolleyExplosion>();
        this.volleyScenarios = new HashMap<VolleyExplosion, TimelineScenario>();
        this.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDown(MouseEvent e) {
                Set set = Fireworks.this.volleys;
                synchronized (set) {
                    for (TimelineScenario scenario : Fireworks.this.volleyScenarios.values()) {
                        scenario.suspend();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent e) {
                Set set = Fireworks.this.volleys;
                synchronized (set) {
                    for (TimelineScenario scenario : Fireworks.this.volleyScenarios.values()) {
                        scenario.resume();
                    }
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!Fireworks.this.firstVolleyInitiated) {
                    Fireworks.this.firstVolleyInitiated = true;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            final int width = (this).Fireworks.this.getBounds().width;
                            final int height = (this).Fireworks.this.getBounds().height;
                            new Thread(){

                                public void run() {
                                    while (true) {
                                        Fireworks.this.addExplosions(5, width, height);
                                    }
                                }
                            }.start();
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExplosions(int count, int width, int height) {
        final CountDownLatch latch = new CountDownLatch(count);
        Random randomizer = new Random();
        int i = 0;
        while (i < count) {
            int r = randomizer.nextInt(255);
            int g = 100 + randomizer.nextInt(155);
            int b = 50 + randomizer.nextInt(205);
            Color color = new Color((Device)Display.getDefault(), r, g, b);
            int x = 60 + randomizer.nextInt(width - 120);
            int y = 60 + randomizer.nextInt(height - 120);
            final VolleyExplosion exp = new VolleyExplosion(x, y, color);
            Set<VolleyExplosion> set = this.volleys;
            synchronized (set) {
                this.volleys.add(exp);
                TimelineScenario scenario = exp.getExplosionScenario();
                scenario.addCallback(new TimelineScenarioCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onTimelineScenarioDone() {
                        Set set = Fireworks.this.volleys;
                        synchronized (set) {
                            Fireworks.this.volleys.remove(exp);
                            Fireworks.this.volleyScenarios.remove(exp);
                            latch.countDown();
                        }
                    }
                });
                this.volleyScenarios.put(exp, scenario);
                scenario.play();
            }
            ++i;
        }
        try {
            latch.await();
        }
        catch (Exception exception) {}
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(480, 320);
        shell.setText("SWT Fireworks");
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        new Fireworks((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public class SingleExplosion {
        float x;
        float y;
        float radius;
        float opacity;
        Color color;

        public SingleExplosion(Color color, float x, float y, float radius) {
            this.color = color;
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.opacity = 1.0f;
        }

        public void setX(float x) {
            this.x = x;
        }

        public void setY(float y) {
            this.y = y;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public void setOpacity(float opacity) {
            this.opacity = opacity;
        }

        public void paint(GC gc) {
            gc.setAlpha((int)(255.0f * this.opacity));
            gc.setBackground(this.color);
            gc.fillOval((int)(this.x - this.radius), (int)(this.y - this.radius), (int)(2.0f * this.radius), (int)(2.0f * this.radius));
        }
    }

    public class VolleyExplosion {
        private int x;
        private int y;
        private Color color;
        private Set<SingleExplosion> circles;

        public VolleyExplosion(int x, int y, Color color) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.circles = new HashSet<SingleExplosion>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimelineScenario getExplosionScenario() {
            TimelineScenario.Parallel scenario = new TimelineScenario.Parallel();
            Random randomizer = new Random();
            int duration = 1000 + randomizer.nextInt(1000);
            int i = 0;
            while (i < 18) {
                float dist = (float)(50.0 + 10.0 * Math.random());
                float radius = (float)(2.0 + 2.0 * Math.random());
                float delta = 0.6f;
                while (delta <= 1.0f) {
                    float circleRadius = radius * delta;
                    double degrees = 20.0 * ((double)i + Math.random());
                    float radians = (float)(Math.PI * 2 * degrees / 360.0);
                    float initDist = delta * dist / 10.0f;
                    float finalDist = delta * dist;
                    float initX = (float)((double)this.x + (double)initDist * Math.cos(radians));
                    float initY = (float)((double)this.y + (double)initDist * Math.sin(radians));
                    float finalX = (float)((double)this.x + (double)finalDist * Math.cos(radians));
                    float finalY = (float)((double)this.y + (double)finalDist * Math.sin(radians));
                    SingleExplosion circle = new SingleExplosion(this.color, initX, initY, circleRadius);
                    Timeline timeline = new Timeline(circle);
                    timeline.addPropertyToInterpolate("x", Float.valueOf(initX), Float.valueOf(finalX));
                    timeline.addPropertyToInterpolate("y", Float.valueOf(initY), Float.valueOf(finalY));
                    timeline.addPropertyToInterpolate("opacity", Float.valueOf(1.0f), Float.valueOf(0.0f));
                    timeline.setDuration(duration - 200 + randomizer.nextInt(400));
                    timeline.setEase(new Spline(0.4f));
                    Set<SingleExplosion> set = this.circles;
                    synchronized (set) {
                        this.circles.add(circle);
                    }
                    scenario.addScenarioActor(timeline);
                    delta += 0.2f;
                }
                ++i;
            }
            return scenario;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(GC gc) {
            gc.setAntialias(1);
            Set<SingleExplosion> set = this.circles;
            synchronized (set) {
                for (SingleExplosion circle : this.circles) {
                    circle.paint(gc);
                }
            }
        }
    }
}

