/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.workbench.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public abstract class XWTTabDescriptorProvider
implements ITabDescriptorProvider {
    private IWorkbenchPart previousPart;
    private ISelection previousSelection;
    private ITabDescriptor[] cachedResult;

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (part != this.previousPart || selection != this.previousSelection) {
            this.previousPart = part;
            this.previousSelection = selection;
            ArrayList<ITabDescriptor> descriptors = new ArrayList<ITabDescriptor>();
            this.addTabDescriptors(descriptors);
            ITabbedPropertySheetPageContributor contributor = part instanceof ITabbedPropertySheetPageContributor ? (ITabbedPropertySheetPageContributor)part : (ITabbedPropertySheetPageContributor)part.getAdapter(ITabbedPropertySheetPageContributor.class);
            if (contributor != null) {
                TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(contributor);
                try {
                    Method method = TabbedPropertyRegistry.class.getDeclaredMethod("getAllTabDescriptors", new Class[0]);
                    method.setAccessible(true);
                    ITabDescriptor[] registeredTabDesriptors = (ITabDescriptor[])method.invoke((Object)registry, new Object[0]);
                    if (registeredTabDesriptors != null) {
                        ITabDescriptor[] iTabDescriptorArray = registeredTabDesriptors;
                        int n = registeredTabDesriptors.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITabDescriptor descriptor = iTabDescriptorArray[n2];
                            if (descriptor.getSectionDescriptors().size() > 0) {
                                descriptors.add(descriptor);
                            }
                            ++n2;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            this.cachedResult = descriptors.toArray(new ITabDescriptor[descriptors.size()]);
        }
        return this.cachedResult;
    }

    protected abstract void addTabDescriptors(List<ITabDescriptor> var1);
}

