/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.gef.core.MultiSelectionContextMenuProvider;

public final class DesignContextMenuProvider
extends MultiSelectionContextMenuProvider {
    private static final String GROUP_BASE = "org.eclipse.wb.popup.group.";
    public static final String GROUP_TOP = "org.eclipse.wb.popup.group.top";
    public static final String GROUP_EDIT = "org.eclipse.wb.popup.group.edit";
    public static final String GROUP_EDIT2 = "org.eclipse.wb.popup.group.edit2";
    public static final String GROUP_EVENTS = "org.eclipse.wb.popup.group.events";
    public static final String GROUP_EVENTS2 = "org.eclipse.wb.popup.group.events2";
    public static final String GROUP_LAYOUT = "org.eclipse.wb.popup.group.layout";
    public static final String GROUP_CONSTRAINTS = "org.eclipse.wb.popup.group.constraints";
    public static final String GROUP_INHERITANCE = "org.eclipse.wb.popup.group.inheritance";
    public static final String GROUP_ADDITIONAL = "org.eclipse.wb.popup.group.additional";
    private final DesignPageActions m_pageActions;
    private List<ObjectInfo> m_selectedObjects;

    public static void addGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator(GROUP_TOP));
        manager.add((IContributionItem)new Separator(GROUP_EDIT));
        manager.add((IContributionItem)new Separator(GROUP_EDIT2));
        manager.add((IContributionItem)new Separator(GROUP_EVENTS));
        manager.add((IContributionItem)new Separator(GROUP_EVENTS2));
        manager.add((IContributionItem)new Separator(GROUP_LAYOUT));
        manager.add((IContributionItem)new Separator(GROUP_CONSTRAINTS));
        manager.add((IContributionItem)new Separator(GROUP_INHERITANCE));
        manager.add((IContributionItem)new Separator(GROUP_ADDITIONAL));
    }

    public DesignContextMenuProvider(IEditPartViewer viewer, DesignPageActions pageActions) {
        super(viewer);
        this.m_pageActions = pageActions;
    }

    protected void preprocessSelection(List<EditPart> editParts) {
        super.preprocessSelection(editParts);
        this.m_selectedObjects = Lists.newArrayList();
        for (EditPart editPart : editParts) {
            if (!(editPart.getModel() instanceof ObjectInfo)) continue;
            this.m_selectedObjects.add((ObjectInfo)editPart.getModel());
        }
    }

    protected void buildContextMenu(final EditPart editPart, final IMenuManager manager) {
        DesignContextMenuProvider.addGroups(manager);
        manager.appendToGroup(GROUP_EDIT, this.m_pageActions.getCutAction());
        manager.appendToGroup(GROUP_EDIT, this.m_pageActions.getCopyAction());
        manager.appendToGroup(GROUP_EDIT, this.m_pageActions.getPasteAction());
        manager.appendToGroup(GROUP_EDIT, this.m_pageActions.getDeleteAction());
        manager.appendToGroup(GROUP_EDIT2, this.m_pageActions.getTestAction());
        manager.appendToGroup(GROUP_EDIT2, this.m_pageActions.getRefreshAction());
        if (editPart.getModel() instanceof ObjectInfo) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ObjectInfo object = (ObjectInfo)editPart.getModel();
                    object.getBroadcastObject().addContextMenu(DesignContextMenuProvider.this.m_selectedObjects, object, manager);
                }
            });
        }
    }
}

