/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d.scroll;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wb.internal.draw2d.scroll.ScrollModel;

public class VerticalScrollModel
extends ScrollModel {
    private final Canvas m_canvas;

    public VerticalScrollModel(Canvas canvas) {
        super(canvas.getVerticalBar());
        this.m_canvas = canvas;
    }

    @Override
    protected void handlePositiveScrolling(int delta, int newSelection) {
        Rectangle clientArea = this.m_canvas.getClientArea();
        this.m_canvas.scroll(0, 0, 0, delta, clientArea.width, clientArea.height - delta, true);
        this.m_selection = newSelection;
        this.m_canvas.redraw(0, clientArea.height - delta, clientArea.width, delta, true);
    }

    @Override
    protected void handleNegativeScrolling(int delta, int newSelection) {
        Rectangle clientArea = this.m_canvas.getClientArea();
        this.m_canvas.scroll(0, delta, 0, 0, clientArea.width, clientArea.height - delta, true);
        this.m_selection = newSelection;
        this.m_canvas.redraw(0, 0, clientArea.width, delta, true);
    }
}

