/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.util;

import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectResolveTag;
import org.eclipse.wb.internal.core.xml.model.utils.NamespacesHelper;
import org.eclipse.wb.internal.xwt.parser.XwtDescriptionProcessor;
import org.eclipse.wb.internal.xwt.parser.XwtParser;

public final class XwtTagResolver
extends NamespacesHelper {
    private final EditorContext m_context;

    public XwtTagResolver(XmlObjectInfo rootObject) {
        super(rootObject.getCreationSupport().getElement());
        this.m_context = rootObject.getContext();
        rootObject.addBroadcastListener((Object)new XmlObjectResolveTag(){

            public void invoke(XmlObjectInfo object, Class<?> clazz, String[] namespace, String[] tag) throws Exception {
                XwtTagResolver.this.invoke0(object, clazz, namespace, tag);
            }
        });
    }

    private void invoke0(XmlObjectInfo object, Class<?> clazz, String[] namespace, String[] tag) throws Exception {
        if (XwtDescriptionProcessor.isXWT(object)) {
            String className = clazz.getName();
            namespace[0] = this.getNamespace(className);
            tag[0] = StringUtils.substringAfterLast((String)className, (String)".");
        }
    }

    private String getNamespace(String className) {
        boolean isForms;
        this.prepareNamespaces();
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        boolean isNotImportedForms = className.equals("org.eclipse.ui.forms.widgets.ColumnLayout") || className.equals("org.eclipse.ui.forms.widgets.ColumnLayoutData") || className.equals("org.eclipse.ui.forms.widgets.TableWrapLayout") || className.equals("org.eclipse.ui.forms.widgets.TableWrapData");
        boolean isStandardCustom = packageName.equals("org.eclipse.swt.custom");
        boolean bl = isForms = XwtParser.hasForms(this.m_context) && packageName.equals("org.eclipse.ui.forms.widgets") && !isNotImportedForms;
        if (packageName.equals("org.eclipse.swt.widgets") || isStandardCustom || packageName.equals("org.eclipse.swt.layout") || packageName.equals("org.eclipse.jface.viewers") || isForms) {
            String name = (String)this.m_nameForURI.get("http://www.eclipse.org/xwt/presentation");
            if (name != null) {
                return name;
            }
            if (!this.m_names.contains("")) {
                return "";
            }
        }
        String packageURI = "clr-namespace:" + packageName;
        return this.ensureName(packageURI, "p");
    }
}

