/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.rcp.databinding.xwt.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.contentproviders.ValidationUiContentProvider;

public class ValidationInfo {
    private List<String> m_classNames = Lists.newArrayList();
    private Map<String, String> m_namespaceToPackage = Maps.newHashMap();
    private final Map<String, String> m_packageToNamespace = Maps.newHashMap();
    private boolean m_update;

    public void parse(DatabindingsProvider provider, DocumentElement validationRules, DocumentElement validationRule) throws Exception {
        List children;
        if (validationRules != null) {
            this.parseNamespaces(validationRules.getRoot());
            for (DocumentElement child : validationRules.getChildren()) {
                this.parseClass(provider, child.getTag());
            }
        } else if (validationRule != null && !(children = validationRule.getChildren()).isEmpty()) {
            this.parseNamespaces(validationRule.getRoot());
            this.parseClass(provider, ((DocumentElement)children.get(0)).getTag());
        }
        this.m_namespaceToPackage = null;
    }

    public void parse(DatabindingsProvider provider, DocumentElement root, String validationRules, String validationRule) throws Exception {
        if (validationRules != null) {
            String[] rules;
            this.parseNamespaces(root);
            String[] stringArray = rules = StringUtils.split((String)StringUtils.substringBetween((String)validationRules, (String)"{", (String)"}"), (char)',');
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                this.parseClass(provider, rule.trim());
                ++n2;
            }
        } else if (validationRule != null) {
            this.parseNamespaces(root);
            this.parseClass(provider, validationRule);
        } else {
            this.parseNamespaces(root);
        }
        this.m_namespaceToPackage = null;
    }

    private void parseNamespaces(DocumentElement root) {
        for (DocumentAttribute attribute : root.getDocumentAttributes()) {
            String value;
            String name = attribute.getName();
            if (!name.startsWith("xmlns:") || !(value = attribute.getValue()).startsWith("clr-namespace:")) continue;
            String namespace = name.substring(6);
            String packageValue = value.substring(14);
            this.m_namespaceToPackage.put(namespace, packageValue);
            this.m_packageToNamespace.put(packageValue, namespace);
        }
    }

    private void parseClass(DatabindingsProvider provider, String value) throws Exception {
        String namespace = StringUtils.substringBefore((String)value, (String)":");
        String packageValue = this.m_namespaceToPackage.get(namespace);
        if (packageValue == null) {
            provider.addWarning(MessageFormat.format(Messages.ValidationInfo_validatorNotFound, value), new Throwable());
        } else {
            String className = String.valueOf(packageValue) + "." + StringUtils.substringAfter((String)value, (String)":");
            try {
                ClassLoader classLoader = provider.getXmlObjectRoot().getContext().getClassLoader();
                classLoader.loadClass(className);
                this.m_classNames.add(className);
            }
            catch (ClassNotFoundException e) {
                provider.addWarning(MessageFormat.format(Messages.ValidationInfo_validatorClassNotFound, className), new Throwable());
            }
        }
    }

    public List<String> getClassNames() {
        return this.m_classNames;
    }

    public void setClassNames(List<String> classNames) {
        this.m_update = true;
        if (!classNames.equals(this.m_classNames)) {
            this.m_classNames = classNames;
        }
    }

    public void appendValue(StringBuffer value) throws Exception {
        if (this.m_update && !this.m_classNames.isEmpty()) {
            if (this.m_classNames.size() == 1) {
                String className = this.m_classNames.get(0);
                String namespace = this.m_packageToNamespace.get(ClassUtils.getPackageName((String)className));
                value.append(", validationRule=" + StringUtils.defaultString((String)namespace) + ":" + ClassUtils.getShortClassName((String)className));
            } else {
                value.append(", validationRules={");
                int index = 0;
                for (String className : this.m_classNames) {
                    if (index++ > 0) {
                        value.append(", ");
                    }
                    String namespace = this.m_packageToNamespace.get(ClassUtils.getPackageName((String)className));
                    value.append(String.valueOf(StringUtils.defaultString((String)namespace)) + ":" + ClassUtils.getShortClassName((String)className));
                }
                value.append("}");
            }
        }
    }

    public boolean update() throws Exception {
        return this.m_update;
    }

    public void applyChanges(AbstractDocumentObject object) throws Exception {
        if (this.m_update) {
            if (object instanceof DocumentAttribute) {
                if (this.m_classNames.size() == 1) {
                    String className = this.m_classNames.get(0);
                    String namespace = this.m_packageToNamespace.get(ClassUtils.getPackageName((String)className));
                    if (namespace == null) {
                        DocumentAttribute attribute = (DocumentAttribute)object;
                        namespace = this.getNamespace(attribute.getEnclosingElement().getRoot(), className);
                        String value = attribute.getValue();
                        int index = value.indexOf("validationRule=") + 15;
                        attribute.setValue(String.valueOf(value.substring(0, index)) + namespace + value.substring(index));
                    }
                } else {
                    ArrayList nonExistingNamespace = Lists.newArrayList();
                    DocumentAttribute attribute = (DocumentAttribute)object;
                    for (String className : this.m_classNames) {
                        String namespace = this.m_packageToNamespace.get(ClassUtils.getPackageName((String)className));
                        if (namespace != null && !nonExistingNamespace.contains(namespace)) continue;
                        if (namespace == null) {
                            namespace = this.getNamespace(attribute.getEnclosingElement().getRoot(), className);
                            nonExistingNamespace.add(namespace);
                        }
                        String value = attribute.getValue();
                        int index = value.indexOf(":" + ClassUtils.getShortClassName((String)className), value.indexOf("validationRules=") + 16);
                        attribute.setValue(String.valueOf(value.substring(0, index)) + namespace + value.substring(index));
                    }
                }
            } else {
                DocumentElement bindingElement = (DocumentElement)object;
                if (this.m_classNames.isEmpty()) {
                    DocumentElement validationRule;
                    DocumentElement validationRules = bindingElement.getChild("Binding.validationRules", true);
                    if (validationRules != null) {
                        validationRules.remove();
                    }
                    if ((validationRule = bindingElement.getChild("Binding.validationRule", true)) != null) {
                        validationRule.remove();
                    }
                } else {
                    DocumentElement validationRules;
                    DocumentElement validationRule = bindingElement.getChild("Binding.validationRule", true);
                    if (validationRule != null) {
                        validationRule.remove();
                    }
                    if ((validationRules = bindingElement.getChild("Binding.validationRules", true)) == null) {
                        validationRules = new DocumentElement("Binding.validationRule");
                        bindingElement.addChild(validationRules);
                    } else {
                        validationRules.removeChildren();
                    }
                    DocumentElement rootElement = bindingElement.getRoot();
                    for (String className : this.m_classNames) {
                        DocumentElement ruleElement = new DocumentElement();
                        ruleElement.setTag(String.valueOf(this.getNamespace(rootElement, className)) + ":" + ClassUtils.getShortClassName((String)className));
                        validationRules.addChild(ruleElement);
                    }
                }
            }
            this.m_update = false;
        }
    }

    private String getNamespace(DocumentElement rootElement, String className) throws Exception {
        String packageValue = ClassUtils.getPackageName((String)className);
        String namespace = this.m_packageToNamespace.get(packageValue);
        if (namespace == null) {
            int index = 0;
            while (this.m_packageToNamespace.containsValue(namespace = "v" + Integer.toString(index))) {
                ++index;
            }
            this.m_packageToNamespace.put(packageValue, namespace);
            rootElement.setAttribute("xmlns:" + namespace, "clr-namespace:" + packageValue);
        }
        return namespace;
    }

    public void createContentProviders(List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        providers.add((IUiContentProvider)new ValidationUiContentProvider(provider, this));
    }
}

