/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.branding.BrandingUtils;
import org.eclipse.wb.core.controls.LineControl;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.controls.flyout.PluginFlyoutPreferences;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignerFlyoutMenuContributor;
import org.eclipse.wb.internal.core.editor.ViewersComposite;
import org.eclipse.wb.internal.core.editor.structure.DesignComponentsComposite;
import org.eclipse.wb.internal.core.gef.EditPartFactory;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.gef.core.EditDomain;
import org.eclipse.wb.internal.gef.graphical.GraphicalViewer;

public abstract class DesignComposite
extends Composite {
    protected final IEditorPart m_editorPart;
    private final ICommandExceptionHandler m_exceptionHandler;
    protected DesignComponentsComposite m_componentsComposite;
    protected ToolBar m_toolBar;
    protected ViewersComposite m_viewersComposite;
    protected GraphicalViewer m_viewer;
    private IExtractableControl m_extractableComponents;

    public DesignComposite(Composite parent, int style, IEditorPart editorPart, ICommandExceptionHandler exceptionHandler) {
        super(parent, style);
        this.m_editorPart = editorPart;
        this.m_exceptionHandler = exceptionHandler;
        this.setLayout((Layout)new FillLayout());
        this.createMainComposite();
        this.createDesignActions();
        this.createDesignToolbarHelper();
    }

    private void createMainComposite() {
        PluginFlyoutPreferences preferences = new PluginFlyoutPreferences(DesignerPlugin.getPreferences(), "design.structure");
        preferences.initializeDefaults(1, 0, 300);
        FlyoutControlComposite mainComposite = new FlyoutControlComposite(this, 0, preferences);
        mainComposite.setTitleText("Structure");
        mainComposite.setMinWidth(200);
        mainComposite.addMenuContributor(new DesignerFlyoutMenuContributor("org.eclipse.wb.core.StructureView"));
        this.m_componentsComposite = new DesignComponentsComposite(mainComposite.getFlyoutParent(), 0);
        this.createEditorComposite(mainComposite.getClientParent());
    }

    private void createEditorComposite(Composite parent) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayoutFactory.create(editorComposite).noMargins().spacingV(0);
        this.m_toolBar = new ToolBar(editorComposite, 0x820000);
        GridDataFactory.create((Control)this.m_toolBar).grabH().fill();
        LineControl separator = new LineControl(editorComposite, 256);
        separator.setBackground(IColorConstants.buttonDarker);
        GridDataFactory.create((Control)separator).grabH().fill();
        this.createGEFComposite(editorComposite);
    }

    protected void createGEFComposite(Composite parent) {
        PluginFlyoutPreferences preferences = new PluginFlyoutPreferences(DesignerPlugin.getPreferences(), "design.palette");
        preferences.initializeDefaults(1, 0, 210);
        FlyoutControlComposite gefComposite = new FlyoutControlComposite(parent, 0, preferences);
        GridDataFactory.create((Control)gefComposite).grab().fill();
        gefComposite.setTitleText("Palette");
        gefComposite.setMinWidth(150);
        gefComposite.setValidDockLocations(3);
        gefComposite.addMenuContributor(new DesignerFlyoutMenuContributor("org.eclipse.wb.core.PaletteView"));
        this.createPalette(gefComposite);
        this.createViewersComposite(gefComposite.getClientParent());
    }

    private void createViewersComposite(Composite parent) {
        this.m_viewersComposite = new ViewersComposite(parent, 0);
        EditDomain domain = new EditDomain();
        domain.setExceptionHandler(this.m_exceptionHandler);
        this.m_viewer = this.m_viewersComposite.getViewer();
        this.m_viewer.getRootFigure().setBackground(IColorConstants.listBackground);
        this.m_viewer.setEditDomain(domain);
        this.m_viewer.setEditPartFactory(EditPartFactory.INSTANCE);
        this.m_viewersComposite.bindViewers();
        this.m_viewer.getRootFigure().addLayer(new Layer("product"){

            @Override
            protected void paintClientArea(Graphics graphics) {
                BrandingUtils.getBranding().paintBrandingOnCanvas(this.getClientArea(), graphics);
            }
        });
    }

    protected abstract void createDesignActions();

    protected abstract void createDesignToolbarHelper();

    protected abstract void createPalette(FlyoutControlComposite var1);

    public boolean setFocus() {
        return this.m_viewersComposite.setFocus();
    }

    public abstract void refresh(ObjectInfo var1, IProgressMonitor var2);

    public void disposeDesign() {
        this.m_viewer.setInput(null);
        if (!this.m_componentsComposite.isDisposed()) {
            this.m_componentsComposite.setInput(this.m_viewer, null);
        }
    }

    public IExtractableControl getExtractableComponents() {
        if (this.m_extractableComponents == null) {
            this.m_extractableComponents = new ExtractableControl((Control)this.m_componentsComposite, this);
        }
        return this.m_extractableComponents;
    }

    public abstract IExtractableControl getExtractablePalette();

    public GraphicalViewer getViewer() {
        return this.m_viewer;
    }

    protected static final class ExtractableControl
    implements IExtractableControl {
        private final Control m_control;
        private final Composite m_terminator;
        private final Composite m_oldParent;

        public ExtractableControl(Control control, Composite terminator) {
            this.m_control = control;
            this.m_terminator = terminator;
            this.m_oldParent = this.m_control.getParent();
        }

        @Override
        public Control getControl() {
            return this.m_control;
        }

        @Override
        public void extract(Composite newParent) {
            this.m_control.setParent(newParent);
            this.doLayout(this.m_oldParent);
            newParent.layout();
        }

        @Override
        public void restore() {
            this.m_control.setParent(this.m_oldParent);
            this.m_control.setVisible(true);
            this.doLayout(this.m_oldParent);
        }

        private void doLayout(Composite composite) {
            if (composite != this.m_terminator) {
                composite.layout();
                this.doLayout(composite.getParent());
            }
        }
    }

    public static interface IExtractableControl {
        public Control getControl();

        public void extract(Composite var1);

        public void restore();
    }
}

