/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import com.google.common.base.Predicate;
import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfosetObjectBefore;
import org.eclipse.wb.core.model.broadcast.ObjectInfoAllProperties;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public abstract class VoidInvocationCreationSupport
extends AbstractFactoryCreationSupport {
    private final JavaInfo m_hostJavaInfo;

    public VoidInvocationCreationSupport(JavaInfo hostJavaInfo, MethodDescription description, MethodInvocation invocation) {
        super(description, invocation);
        this.m_hostJavaInfo = hostJavaInfo;
    }

    public VoidInvocationCreationSupport(JavaInfo hostJavaInfo, MethodDescription description) {
        super(description);
        this.m_hostJavaInfo = hostJavaInfo;
    }

    public String toString() {
        return "void";
    }

    @Override
    public boolean canUseParent(JavaInfo parent) throws Exception {
        return super.canUseParent(parent);
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_javaInfo.addBroadcastListener(new JavaInfosetObjectBefore(){

            @Override
            public void invoke(JavaInfo target, Object[] objectRef) throws Exception {
                if (target == VoidInvocationCreationSupport.this.m_javaInfo) {
                    if (VoidInvocationCreationSupport.this.m_javaInfo.getCreationSupport() == VoidInvocationCreationSupport.this) {
                        Object hostObject = VoidInvocationCreationSupport.this.m_hostJavaInfo.getObject();
                        objectRef[0] = VoidInvocationCreationSupport.this.getObject(hostObject);
                    } else {
                        VoidInvocationCreationSupport.this.m_javaInfo.removeBroadcastListener(this);
                    }
                }
            }
        });
        this.m_javaInfo.addBroadcastListener(new ObjectInfoAllProperties(){

            public void invoke(ObjectInfo object, List<Property> properties) throws Exception {
                if (object == VoidInvocationCreationSupport.this.m_javaInfo && !VoidInvocationCreationSupport.this.m_description.hasTrueTag("voidFactory.dontFilterProperties")) {
                    Predicate predicate = PropertyUtils.getIncludeByTitlePredicate((String[])new String[]{"Factory"});
                    PropertyUtils.filterProperties(properties, (Predicate)predicate);
                }
            }
        });
    }

    protected abstract Object getObject(Object var1) throws Exception;

    public final void setInvocation(MethodInvocation invocation) {
        this.m_invocation = invocation;
        this.m_javaInfo.bindToExpression((Expression)invocation);
    }

    protected abstract String add_getMethodSource() throws Exception;

    @Override
    public final String add_getSource(NodeTarget target) throws Exception {
        return TemplateUtils.format("{0}.{1}", new Object[]{this.m_hostJavaInfo, this.add_getMethodSource()});
    }

    @Override
    public final void add_setSourceExpression(Expression expression) throws Exception {
        this.setInvocation((MethodInvocation)expression);
    }
}

