/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

public final class UiUtils {
    public static TableColumn createSmartColumn(Table table, final IDialogSettings settings, final String key, int defautWidth) {
        final TableColumn column = new TableColumn(table, 0);
        try {
            int width = settings.getInt(key);
            if (width == 0) {
                width = defautWidth;
            }
            column.setWidth(width);
        }
        catch (Throwable e) {
            column.setWidth(defautWidth);
            settings.put(key, defautWidth);
        }
        column.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                settings.put(key, column.getWidth());
            }
        });
        return column;
    }

    public static void loadSashWeights(SashForm sash, IDialogSettings settings, String key, int[] defaultWeights) {
        try {
            int x = settings.getInt(String.valueOf(key) + ".x");
            int y = settings.getInt(String.valueOf(key) + ".y");
            sash.setWeights(new int[]{x, y});
        }
        catch (Throwable e) {
            sash.setWeights(defaultWeights);
            Assert.isLegal((defaultWeights.length == 2 ? 1 : 0) != 0);
            settings.put(String.valueOf(key) + ".x", defaultWeights[0]);
            settings.put(String.valueOf(key) + ".y", defaultWeights[1]);
        }
    }

    public static void saveSashWeights(SashForm sash, IDialogSettings settings, String key) {
        int[] weights = sash.getWeights();
        Assert.isLegal((weights.length == 2 ? 1 : 0) != 0);
        settings.put(String.valueOf(key) + ".x", weights[0]);
        settings.put(String.valueOf(key) + ".y", weights[1]);
    }

    public static void setBoldFont(Label label) {
        label.setFont(SwtResourceManager.getBoldFont((Font)label.getFont()));
    }

    public static IDialogSettings getSettings(IDialogSettings mainSettings, String sectionName) {
        IDialogSettings settings = mainSettings.getSection(sectionName);
        return settings == null ? mainSettings.addNewSection(sectionName) : settings;
    }

    public static boolean isEmpty(ISelection selection) {
        return selection == null || selection.isEmpty();
    }

    public static IStructuredSelection getSelection(Viewer viewer) {
        return (IStructuredSelection)viewer.getSelection();
    }

    public static String chooseType(Shell shell, IJavaProject project, String baseClassName, int style) throws Exception {
        IType classType;
        IJavaSearchScope scope = null;
        if (project != null && baseClassName != null && (classType = project.findType(baseClassName)) != null) {
            scope = SearchEngine.createHierarchyScope((IType)classType);
        }
        return UiUtils.chooseType(shell, scope, style);
    }

    public static String chooseType(Shell shell, IJavaProject project, String[] baseClassNames, int style) throws Exception {
        MultiHierarchyScope scope = null;
        if (project != null && !ArrayUtils.isEmpty((Object[])baseClassNames)) {
            IJavaSearchScope[] scopes = new IJavaSearchScope[baseClassNames.length];
            int i = 0;
            while (i < scopes.length) {
                IType classType = project.findType(baseClassNames[i]);
                if (classType != null) {
                    scopes[i] = SearchEngine.createHierarchyScope((IType)classType);
                }
                ++i;
            }
            scope = scopes.length == 1 ? scopes[0] : new MultiHierarchyScope(scopes);
        }
        return UiUtils.chooseType(shell, scope, style);
    }

    public static String chooseType(Shell shell, IJavaSearchScope scope, int style) throws Exception {
        ProgressMonitorDialog context = new ProgressMonitorDialog(shell);
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)scope, (int)style, (boolean)false);
        dialog.setTitle(Messages.UiUtils_openTypeTitle);
        dialog.setMessage(Messages.UiUtils_openTypeMessage);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getResult()[0];
            return type.getFullyQualifiedName().replace('$', '.');
        }
        return null;
    }

    public static String getPresentationText(IObserveInfo object, IObserveInfo property) throws Exception {
        String objectPresentation = object.getPresentation().getTextForBinding();
        String propertyPresentation = property.getPresentation().getTextForBinding();
        String separator = propertyPresentation.length() == 0 ? "" : ".";
        return String.valueOf(objectPresentation) + separator + propertyPresentation;
    }

    private static class MultiHierarchyScope
    implements IJavaSearchScope {
        private final IJavaSearchScope[] m_scopes;

        public MultiHierarchyScope(IJavaSearchScope[] scopes) {
            this.m_scopes = scopes;
        }

        public boolean encloses(String resourcePath) {
            IJavaSearchScope[] iJavaSearchScopeArray = this.m_scopes;
            int n = this.m_scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaSearchScope scope = iJavaSearchScopeArray[n2];
                if (scope != null && scope.encloses(resourcePath)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean encloses(IJavaElement element) {
            IJavaSearchScope[] iJavaSearchScopeArray = this.m_scopes;
            int n = this.m_scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaSearchScope scope = iJavaSearchScopeArray[n2];
                if (scope != null && scope.encloses(element)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public IPath[] enclosingProjectsAndJars() {
            IJavaSearchScope[] iJavaSearchScopeArray = this.m_scopes;
            int n = this.m_scopes.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaSearchScope scope = iJavaSearchScopeArray[n2];
                if (scope != null) {
                    return scope.enclosingProjectsAndJars();
                }
                ++n2;
            }
            return null;
        }

        public boolean includesBinaries() {
            return true;
        }

        public boolean includesClasspaths() {
            return true;
        }

        public void setIncludesBinaries(boolean includesBinaries) {
        }

        public void setIncludesClasspaths(boolean includesClasspaths) {
        }
    }
}

