/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.utils.ui.PixelConverter;

public final class GridDataFactory {
    private final Control m_control;
    private final PixelConverter m_pixelConverter;
    private final GridData m_data;

    private GridDataFactory(Control control, GridData gridData) {
        this.m_control = control;
        this.m_pixelConverter = new PixelConverter(this.m_control);
        this.m_data = gridData;
        if (this.m_control.getLayoutData() != this.m_data) {
            this.m_control.setLayoutData((Object)this.m_data);
        }
    }

    public static GridDataFactory create(Control control) {
        return new GridDataFactory(control, new GridData());
    }

    public static GridDataFactory modify(Control control) {
        Object existingLayoutData = control.getLayoutData();
        GridData gridData = existingLayoutData instanceof GridData ? (GridData)existingLayoutData : new GridData();
        return new GridDataFactory(control, gridData);
    }

    public GridDataFactory span(int hSpan, int vSpan) {
        this.m_data.horizontalSpan = hSpan;
        this.m_data.verticalSpan = vSpan;
        return this;
    }

    public GridDataFactory spanH(int hSpan) {
        this.m_data.horizontalSpan = hSpan;
        return this;
    }

    public GridDataFactory spanV(int vSpan) {
        this.m_data.verticalSpan = vSpan;
        return this;
    }

    public GridDataFactory hint(int xHint, int yHint) {
        this.m_data.widthHint = xHint;
        this.m_data.heightHint = yHint;
        return this;
    }

    public GridDataFactory hintC(int xHintInChars, int yHintInChars) {
        this.hintHC(xHintInChars);
        this.hintVC(yHintInChars);
        return this;
    }

    public GridDataFactory hintH(int xHint) {
        this.m_data.widthHint = xHint;
        return this;
    }

    public GridDataFactory hintHMin(int otherHint) {
        this.m_data.widthHint = Math.min(this.m_data.widthHint, otherHint);
        return this;
    }

    public GridDataFactory hintHC(int hintInChars) {
        return this.hintH(this.m_pixelConverter.convertWidthInCharsToPixels(hintInChars));
    }

    public GridDataFactory hintHU(int hintInDLU) {
        return this.hintH(this.m_pixelConverter.convertHorizontalDLUsToPixels(hintInDLU));
    }

    public GridDataFactory hintV(int yHint) {
        this.m_data.heightHint = yHint;
        return this;
    }

    public GridDataFactory hintVC(int hintInChars) {
        return this.hintV(this.m_pixelConverter.convertHeightInCharsToPixels(hintInChars));
    }

    public GridDataFactory hintHAdd(int increment) {
        return this.hintV(this.m_data.widthHint + increment);
    }

    public GridDataFactory hintVAdd(int increment) {
        return this.hintV(this.m_data.heightHint + increment);
    }

    public GridDataFactory hint(Point hint) {
        this.m_data.widthHint = hint.x;
        this.m_data.heightHint = hint.y;
        return this;
    }

    public GridDataFactory minH(int minimumWidth) {
        this.m_data.minimumWidth = minimumWidth;
        return this;
    }

    public GridDataFactory minHC(int widthInChars) {
        return this.minH(this.m_pixelConverter.convertWidthInCharsToPixels(widthInChars));
    }

    public GridDataFactory minV(int minimumHeight) {
        this.m_data.minimumHeight = minimumHeight;
        return this;
    }

    public GridDataFactory minVC(int heightInChars) {
        return this.minV(this.m_pixelConverter.convertHeightInCharsToPixels(heightInChars));
    }

    public GridDataFactory align(int hAlign, int vAlign) {
        this.m_data.horizontalAlignment = hAlign;
        this.m_data.verticalAlignment = vAlign;
        return this;
    }

    public GridDataFactory fill() {
        return this.align(4, 4);
    }

    public GridDataFactory alignH(int hAlign) {
        this.m_data.horizontalAlignment = hAlign;
        return this;
    }

    public GridDataFactory alignHL() {
        return this.alignH(1);
    }

    public GridDataFactory alignHC() {
        return this.alignH(2);
    }

    public GridDataFactory alignHF() {
        return this.alignH(4);
    }

    public GridDataFactory fillH() {
        return this.alignHF();
    }

    public GridDataFactory alignHR() {
        return this.alignH(3);
    }

    public GridDataFactory alignV(int vAlign) {
        this.m_data.verticalAlignment = vAlign;
        return this;
    }

    public GridDataFactory alignVT() {
        return this.alignV(1);
    }

    public GridDataFactory alignVM() {
        return this.alignV(2);
    }

    public GridDataFactory alignVF() {
        return this.alignV(4);
    }

    public GridDataFactory fillV() {
        return this.alignVF();
    }

    public GridDataFactory alignVB() {
        return this.alignV(3);
    }

    public GridDataFactory indentH(int hIndent) {
        this.m_data.horizontalIndent = hIndent;
        return this;
    }

    public GridDataFactory indentHC(int hIndent) {
        this.m_data.horizontalIndent = this.m_pixelConverter.convertWidthInCharsToPixels(hIndent);
        return this;
    }

    public GridDataFactory grab(boolean horizontal, boolean vertical) {
        this.m_data.grabExcessHorizontalSpace = horizontal;
        this.m_data.grabExcessVerticalSpace = vertical;
        return this;
    }

    public GridDataFactory grabH() {
        this.m_data.grabExcessHorizontalSpace = true;
        return this;
    }

    public GridDataFactory grabV() {
        this.m_data.grabExcessVerticalSpace = true;
        return this;
    }

    public GridDataFactory grab() {
        return this.grab(true, true);
    }

    public GridDataFactory exclude(boolean value) {
        this.m_data.exclude = value;
        return this;
    }
}

