/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.association;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.DirectAssociation;
import org.eclipse.wb.internal.core.xml.model.utils.ElementTarget;

public final class IntermediateAssociation
extends DirectAssociation {
    private final String m_name;
    private Map<String, String> m_attributes;

    public IntermediateAssociation(String name) {
        this.m_name = name;
    }

    @Override
    public String toString() {
        String s = "inter " + this.m_name;
        if (this.m_attributes != null) {
            s = String.valueOf(s) + " " + this.m_attributes;
        }
        return s;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.m_attributes = attributes;
    }

    @Override
    public void add(XmlObjectInfo object, ElementTarget target) throws Exception {
        target = this.prepareTarget(target);
        super.add(object, target);
    }

    @Override
    public void move(XmlObjectInfo object, ElementTarget target, XmlObjectInfo oldParent, XmlObjectInfo newParent) throws Exception {
        if (newParent == oldParent) {
            DocumentElement targetElement = target.getElement();
            int targetIndex = target.getIndex();
            targetElement.moveChild(object.getElement().getParent(), targetIndex);
            return;
        }
        target = this.prepareTarget(target);
        super.move(object, target, oldParent, newParent);
    }

    private ElementTarget prepareTarget(ElementTarget target) {
        DocumentElement targetElement = target.getElement();
        int targetIndex = target.getIndex();
        DocumentElement interElement = new DocumentElement();
        String tag = this.m_name;
        tag = StringUtils.replace((String)tag, (String)"{parentNS}", (String)targetElement.getTagNS());
        interElement.setTag(tag);
        targetElement.addChild(interElement, targetIndex);
        if (this.m_attributes != null) {
            for (Map.Entry<String, String> entry : this.m_attributes.entrySet()) {
                interElement.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return new ElementTarget(interElement, 0);
    }
}

