/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.generic;

import java.beans.PropertyDescriptor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.text.MessageFormat;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.binding.DesignerTypeBinding;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swing.databinding.model.generic.ClassGenericType;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericTypeContainer;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;
import org.eclipse.wb.internal.swing.databinding.parser.DatabindingParser;

public class GenericUtils {
    public static IGenericType[] getReturnTypeArguments(AstEditor editor, MethodInvocation invocation, int count) throws Exception {
        ITypeBinding[] typeArguments = AstNodeUtils.getMethodBinding((MethodInvocation)invocation).getTypeArguments();
        return GenericUtils.getObjectTypes(editor, typeArguments, count);
    }

    public static IGenericType[] getObjectTypes(AstEditor editor, ITypeBinding[] bindings, int count) throws Exception {
        Object[] types = new IGenericType[count];
        if (bindings.length == types.length) {
            ClassLoader classLoader = EditorState.get((AstEditor)editor).getEditorLoader();
            int i = 0;
            while (i < types.length) {
                types[i] = GenericUtils.getObjectType(classLoader, bindings[i]);
                ++i;
            }
        } else {
            Arrays.fill(types, ClassGenericType.OBJECT_CLASS);
        }
        return types;
    }

    public static IGenericType getCreationType(AstEditor editor, ClassInstanceCreation creation) throws Exception {
        ITypeBinding binding = AstNodeUtils.getTypeBinding((Expression)creation);
        return GenericUtils.getObjectType(editor, binding);
    }

    public static IGenericType getObjectType(AstEditor editor, ITypeBinding binding) throws Exception {
        ClassLoader classLoader = EditorState.get((AstEditor)editor).getEditorLoader();
        return GenericUtils.getObjectType(classLoader, binding);
    }

    private static IGenericType getObjectType(ClassLoader classLoader, ITypeBinding binding) throws Exception {
        Class rawType = ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)true));
        String typeName = null;
        if (!(binding instanceof DesignerTypeBinding)) {
            if (binding.isWildcardType() && binding.getBound() == null) {
                return ClassGenericType.WILDCARD;
            }
            typeName = GenericUtils.resolveTypeName(binding);
            if (binding.isParameterizedType()) {
                GenericTypeContainer genericType = new GenericTypeContainer(rawType);
                ITypeBinding[] iTypeBindingArray = binding.getTypeArguments();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding subBinding = iTypeBindingArray[n2];
                    genericType.getSubTypes().add(GenericUtils.getObjectType(classLoader, subBinding));
                    ++n2;
                }
                return genericType;
            }
            if (binding.isArray() && rawType.isArray() && !rawType.getComponentType().isPrimitive()) {
                GenericTypeContainer genericType = new GenericTypeContainer(rawType, binding.getDimensions());
                genericType.getSubTypes().add(GenericUtils.getObjectType(classLoader, binding.getElementType()));
                return genericType;
            }
        }
        return new ClassGenericType(rawType, typeName, null);
    }

    private static String resolveTypeName(ITypeBinding binding) throws Exception {
        if (binding.isArray()) {
            StringBuffer fullName = new StringBuffer();
            int i = 0;
            while (i < binding.getDimensions()) {
                fullName.append("[]");
                ++i;
            }
            fullName.insert(0, GenericUtils.resolveTypeName(binding.getElementType()));
            return fullName.toString();
        }
        if (binding.isWildcardType()) {
            ITypeBinding boundType = binding.getBound();
            if (boundType == null) {
                return "?";
            }
            String fullName = binding.isUpperbound() ? "? extends " : "? super ";
            return String.valueOf(fullName) + GenericUtils.resolveTypeName(boundType);
        }
        if (binding.isTypeVariable()) {
            return binding.getName();
        }
        String className = AstNodeUtils.getFullyQualifiedName((ITypeBinding)binding, (boolean)false);
        if (binding.isParameterizedType()) {
            StringBuffer fullName = new StringBuffer();
            fullName.append(className);
            fullName.append("<");
            ITypeBinding[] types = binding.getTypeArguments();
            int i = 0;
            while (i < types.length) {
                if (i > 0) {
                    fullName.append(", ");
                }
                fullName.append(GenericUtils.resolveTypeName(types[i]));
                ++i;
            }
            fullName.append(">");
            return fullName.toString();
        }
        return GenericUtils.convertPrimitiveType(className);
    }

    public static IGenericType getObjectType(TypeVariable<?> superTypeParameter, Type superTypeParameterClass, PropertyDescriptor descriptor) {
        Method readMethod = descriptor.getReadMethod();
        Class<?> rawType = descriptor.getPropertyType();
        if (readMethod == null) {
            return new ClassGenericType(rawType, null, null);
        }
        Type type = readMethod.getGenericReturnType();
        if (type instanceof Class || type instanceof TypeVariable) {
            return new ClassGenericType(rawType, null, null);
        }
        if (type instanceof ParameterizedType) {
            GenericTypeContainer genericType = new GenericTypeContainer(rawType);
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (superTypeParameter != null && parameterizedType.getActualTypeArguments().length == 1 && superTypeParameter == parameterizedType.getActualTypeArguments()[0]) {
                genericType.getSubTypes().add(GenericUtils.resolveType(superTypeParameterClass));
                return genericType;
            }
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type subType = typeArray[n2];
                genericType.getSubTypes().add(GenericUtils.resolveType(subType));
                ++n2;
            }
            return genericType;
        }
        if (type instanceof GenericArrayType) {
            int dimension = 0;
            Type elementType = null;
            GenericArrayType arrayType = (GenericArrayType)type;
            while (true) {
                ++dimension;
                elementType = arrayType.getGenericComponentType();
                if (!(elementType instanceof GenericArrayType)) break;
                arrayType = (GenericArrayType)elementType;
            }
            GenericTypeContainer genericType = new GenericTypeContainer(rawType, dimension);
            genericType.getSubTypes().add(GenericUtils.resolveType(elementType));
            return genericType;
        }
        Assert.fail((String)MessageFormat.format("Undefine type: {0} {1}", readMethod, rawType));
        return null;
    }

    private static IGenericType resolveType(Type type) {
        WildcardType wildcardType;
        if (type instanceof Class) {
            return new ClassGenericType((Class)type, null, null);
        }
        if (type instanceof WildcardType && ArrayUtils.isEmpty((Object[])(wildcardType = (WildcardType)type).getUpperBounds()) && ArrayUtils.isEmpty((Object[])wildcardType.getLowerBounds())) {
            return ClassGenericType.WILDCARD;
        }
        if (type instanceof ParameterizedType || type instanceof GenericArrayType || type instanceof WildcardType) {
            return new ClassGenericType(null, GenericUtils.resolveTypeName(type), "???");
        }
        if (type instanceof TypeVariable) {
            return ClassGenericType.WILDCARD;
        }
        Assert.fail((String)MessageFormat.format("Undefine type: {0}", type));
        return null;
    }

    private static String resolveTypeName(Type type) {
        if (type instanceof Class) {
            Class rawType = (Class)type;
            return GenericUtils.convertPrimitiveType(ReflectionUtils.getFullyQualifiedName((Type)rawType, (boolean)false));
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            StringBuffer fullName = new StringBuffer();
            fullName.append(CoreUtils.getClassName((Class)rawType));
            fullName.append("<");
            Type[] types = parameterizedType.getActualTypeArguments();
            int i = 0;
            while (i < types.length) {
                if (i > 0) {
                    fullName.append(", ");
                }
                fullName.append(GenericUtils.resolveTypeName(types[i]));
                ++i;
            }
            fullName.append(">");
            return fullName.toString();
        }
        if (type instanceof GenericArrayType) {
            StringBuffer fullName = new StringBuffer();
            Type elementType = null;
            GenericArrayType arrayType = (GenericArrayType)type;
            while (true) {
                fullName.append("[]");
                elementType = arrayType.getGenericComponentType();
                if (!(elementType instanceof GenericArrayType)) break;
                arrayType = (GenericArrayType)elementType;
            }
            fullName.insert(0, GenericUtils.resolveTypeName(elementType));
            return fullName.toString();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Object[] upperBounds = wildcardType.getUpperBounds();
            Object[] lowerBounds = wildcardType.getLowerBounds();
            if (!ArrayUtils.isEmpty((Object[])upperBounds)) {
                boolean isWildcard;
                Object upperBound = upperBounds[0];
                boolean bl = isWildcard = upperBound instanceof Class && ((Class)upperBound).getName().equals("java.lang.Object");
                if (!isWildcard) {
                    return "? extends " + GenericUtils.resolveTypeName((Type)upperBound);
                }
            } else if (!ArrayUtils.isEmpty((Object[])lowerBounds)) {
                return "? super " + GenericUtils.resolveTypeName((Type)lowerBounds[0]);
            }
            return "?";
        }
        if (type instanceof TypeVariable) {
            return "?";
        }
        Assert.fail((String)("Undefine type: " + type));
        return null;
    }

    public static String convertPrimitiveType(String className) {
        if ("boolean".equals(className)) {
            return "java.lang.Boolean";
        }
        if ("char".equals(className)) {
            return "java.lang.Character";
        }
        if ("byte".equals(className)) {
            return "java.lang.Byte";
        }
        if ("short".equals(className)) {
            return "java.lang.Short";
        }
        if ("int".equals(className)) {
            return "java.lang.Integer";
        }
        if ("long".equals(className)) {
            return "java.lang.Long";
        }
        if ("float".equals(className)) {
            return "java.lang.Float";
        }
        if ("double".equals(className)) {
            return "java.lang.Double";
        }
        return className;
    }

    public static String getTypesSource(IGenericType ... types) {
        StringBuffer line = new StringBuffer();
        line.append("<");
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                line.append(", ");
            }
            line.append(types[i].getFullTypeName());
            ++i;
        }
        line.append(">");
        return line.toString();
    }

    public static void assertEquals(IGenericType expected, IGenericType actual) {
        if (DatabindingParser.useGenerics && !expected.getFullTypeName().equals(actual.getFullTypeName())) {
            Class<?> actualClass = actual.getRawType();
            Class<?> expectedClass = expected.getRawType();
            if (actualClass != null && expectedClass != null && actualClass.isAssignableFrom(expectedClass)) {
                return;
            }
            Assert.fail((String)MessageFormat.format("Generic: {0} expected, but {1} found", expected.getFullTypeName(), actual.getFullTypeName()));
        }
    }
}

