"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = getElementAttrs;
function getElementAttrs(ts, program, tag) {
    const checker = program.getTypeChecker();
    const elements = checker.resolveName('__VLS_intrinsics', undefined, ts.SymbolFlags.Variable, false);
    if (!elements) {
        return [];
    }
    const elementType = checker.getTypeOfSymbol(elements).getProperty(tag);
    if (!elementType) {
        return [];
    }
    return checker.getTypeOfSymbol(elementType).getProperties().map(c => c.name);
}
//# sourceMappingURL=getElementAttrs.js.map