/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileDialog
extends PopupDialog {
    private final LSSymbolsContentProvider.OutlineViewerInput outlineViewerInput;
    private final ITextEditor textEditor;
    private TreeViewer viewer;

    public LSPSymbolInFileDialog(@NonNull Shell parentShell, @NonNull ITextEditor textEditor, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
        super(parentShell, 16, true, true, true, false, false, null, null);
        this.outlineViewerInput = new LSSymbolsContentProvider.OutlineViewerInput(document, wrapper, textEditor);
        this.textEditor = textEditor;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        IFile documentFile = this.outlineViewerInput.documentFile;
        this.getShell().setText(NLS.bind((String)Messages.symbolsInFile, (Object)(documentFile == null ? null : documentFile.getName())));
        FilteredTree filteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true, false);
        this.viewer = filteredTree.getViewer();
        this.viewer.setData("isQuickOutline", (Object)Boolean.TRUE);
        NavigatorContentService contentService = new NavigatorContentService("org.eclipse.lsp4e.outline", (StructuredViewer)this.viewer);
        filteredTree.addDisposeListener(ev -> contentService.dispose());
        ITreeContentProvider contentProvider = contentService.createCommonContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        CommonViewerSorter sorter = new CommonViewerSorter();
        sorter.setContentService((INavigatorContentService)contentService);
        this.viewer.setComparator((ViewerComparator)sorter);
        this.viewer.setLabelProvider((IBaseLabelProvider)new NavigatorDecoratingLabelProvider(contentService.createCommonLabelProvider()));
        this.viewer.setUseHashlookup(true);
        final Tree tree = this.viewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    LSPSymbolInFileDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LSPSymbolInFileDialog.this.gotoSelectedElement();
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TreeItem selection;
                if (tree.getSelectionCount() < 1 || e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource()) && (selection = tree.getSelection()[0]).equals(tree.getItem(new Point(e.x, e.y)))) {
                    LSPSymbolInFileDialog.this.gotoSelectedElement();
                }
            }
        });
        this.getShell().addDisposeListener(event -> {
            TreeViewer treeViewer = this.viewer = null;
        });
        this.viewer.setInput((Object)this.outlineViewerInput);
        return filteredTree;
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.close();
            Range range = null;
            if (selectedElement instanceof SymbolInformation) {
                SymbolInformation symbolInformation = (SymbolInformation)selectedElement;
                range = symbolInformation.getLocation().getRange();
            } else if (selectedElement instanceof DocumentSymbol) {
                DocumentSymbol documentSymbol = (DocumentSymbol)selectedElement;
                range = documentSymbol.getSelectionRange();
            } else if (selectedElement instanceof SymbolsModel.DocumentSymbolWithURI) {
                SymbolsModel.DocumentSymbolWithURI documentSymbolWithFile = (SymbolsModel.DocumentSymbolWithURI)selectedElement;
                range = documentSymbolWithFile.symbol.getSelectionRange();
            }
            if (range != null) {
                try {
                    int offset = LSPEclipseUtils.toOffset(range.getStart(), this.outlineViewerInput.document);
                    int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), this.outlineViewerInput.document);
                    this.textEditor.selectAndReveal(offset, endOffset - offset);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }

    private Object getSelectedElement() {
        TreeViewer treeViewer = this.viewer;
        if (treeViewer == null) {
            return null;
        }
        ITreeSelection selection = treeViewer.getStructuredSelection();
        if (selection == null) {
            return null;
        }
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof Either) {
            Either either = (Either)selectedElement;
            selectedElement = either.get();
        }
        return selectedElement;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(280, 300);
        Control control = (Control)this.textEditor.getAdapter(Control.class);
        if (control != null) {
            shell.setLocation(control.toDisplay(control.getBounds().width - shell.getSize().x, control.getLocation().y));
        }
    }
}

