/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class LSPDocumentAbstractHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITextEditor textEditor = UI.asTextEditor(HandlerUtil.getActiveEditor((ExecutionEvent)event));
        if (textEditor != null) {
            this.execute(event, textEditor);
        }
        return null;
    }

    protected abstract void execute(ExecutionEvent var1, ITextEditor var2);

    protected boolean hasSelection(ITextEditor textEditor) {
        ISelection selection;
        ISelectionProvider provider = textEditor.getSelectionProvider();
        ISelection iSelection = selection = provider == null ? null : provider.getSelection();
        return selection instanceof ITextSelection && !selection.isEmpty();
    }

    protected void setEnabled(@NonNull Function<ServerCapabilities, Either<Boolean, ? extends Object>> serverCapabilities, Predicate<ITextEditor> condition) {
        Predicate<ServerCapabilities> filter = f -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)((Either)serverCapabilities.apply((ServerCapabilities)f)));
        this.setEnabled(filter, condition);
    }

    protected void setEnabled(@NonNull Predicate<ServerCapabilities> filter, Predicate<ITextEditor> condition) {
        IDocument document;
        ITextEditor textEditor = UI.getActiveTextEditor();
        if (textEditor != null && condition.test(textEditor) && (document = LSPEclipseUtils.getDocument(textEditor)) != null) {
            this.setBaseEnabled(((LanguageServerDocumentHandlerExecutor)new LanguageServerDocumentHandlerExecutor(document).withFilter((Predicate)filter)).anyMatching(() -> this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false))));
            return;
        }
        this.setBaseEnabled(false);
    }

    private static class LanguageServerDocumentHandlerExecutor
    extends LanguageServers.LanguageServerDocumentExecutor {
        LanguageServerDocumentHandlerExecutor(@NonNull IDocument document) {
            super(document);
        }

        boolean anyMatching(Runnable runner) {
            return this.getServers().stream().filter(wF -> this.matches((CompletableFuture<LanguageServerWrapper>)wF, runner)).findFirst().isPresent();
        }

        @Override
        public @NonNull LanguageServerDocumentHandlerExecutor withFilter(@NonNull Predicate<ServerCapabilities> filter) {
            return (LanguageServerDocumentHandlerExecutor)super.withFilter(filter);
        }

        Boolean matches(@NonNull CompletableFuture<@Nullable LanguageServerWrapper> wrapperFuture, Runnable runner) {
            try {
                return (Boolean)((CompletableFuture)wrapperFuture.thenApply(Objects::nonNull)).get(50L, TimeUnit.MILLISECONDS);
            }
            catch (java.util.concurrent.ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                wrapperFuture.thenAcceptAsync(w -> {
                    if (w != null) {
                        runner.run();
                    }
                });
                return Boolean.FALSE;
            }
            return Boolean.FALSE;
        }
    }
}

