/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.LSPDocumentAbstractHandler;
import org.eclipse.lsp4e.operations.references.LSSearchQuery;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSFindReferences
extends LSPDocumentAbstractHandler
implements IHandler {
    @Override
    protected void execute(ExecutionEvent event, ITextEditor textEditor) {
        ISelection sel = textEditor.getSelectionProvider().getSelection();
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            IDocument document = LSPEclipseUtils.getDocument(textEditor);
            if (document != null) {
                try {
                    LSSearchQuery query = new LSSearchQuery(textSelection.getOffset(), document);
                    HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay().asyncExec(() -> NewSearchUI.runQueryInBackground((ISearchQuery)query));
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        this.setEnabled(ServerCapabilities::getReferencesProvider, this::hasSelection);
    }

    public boolean isHandled() {
        return true;
    }
}

