import { MappedPosition, ISourcePathDetails } from './sourceMap';
import { ISourceMapPathOverrides, IPathMapping } from '../debugAdapterInterfaces';
export declare class SourceMaps {
    private _generatedPathToSourceMap;
    private _authoredPathToSourceMap;
    private _sourceMapFactory;
    constructor(pathMapping?: IPathMapping, sourceMapPathOverrides?: ISourceMapPathOverrides, enableSourceMapCaching?: boolean);
    /**
     * Returns the generated script path for an authored source path
     * @param pathToSource - The absolute path to the authored file
     */
    getGeneratedPathFromAuthoredPath(authoredPath: string): string;
    mapToGenerated(authoredPath: string, line: number, column: number): MappedPosition;
    mapToAuthored(pathToGenerated: string, line: number, column: number): MappedPosition;
    allMappedSources(pathToGenerated: string): string[];
    allSourcePathDetails(pathToGenerated: string): ISourcePathDetails[];
    sourceContentFor(authoredPath: string): string;
    /**
     * Given a new path to a new script file, finds and loads the sourcemap for that file
     */
    processNewSourceMap(pathToGenerated: string, originalUrlToGenerated: string | undefined, sourceMapURL: string, isVSClient?: boolean): Promise<void>;
}
