/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml.ui.preferences;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.SchemaAssociationRegistry;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public class YAMLPreferenceServerConstants {
    private static final String YAML_SECTION = "yaml";
    public static final String YAML_PREFERENCES_SCHEMAS = "yaml.schemas";
    public static final String YAML_PREFERENCES_SCHEMASTORE_ENABLE = "yaml.schemaStore.enable";
    public static final String YAML_PREFERENCES_SCHEMASTORE_URL = "yaml.schemaStore.url";
    public static final String YAML_PREFERENCES_MAXITEMSCOMPUTED = "yaml.maxItemsComputed";
    public static final String YAML_PREFERENCES_COMPLETION = "yaml.completion";
    public static final String YAML_PREFERENCES_SUGGEST_PARENTSKELETONSELECTEDFIRST = "yaml.suggest.parentSkeletonSelectedFirst";
    public static final String YAML_PREFERENCES_DISABLEDEFAULTPROPERTIES = "yaml.disableDefaultProperties";
    public static final String YAML_PREFERENCES_FORMAT_ENABLE = "yaml.format.enable";
    public static final String YAML_PREFERENCES_FORMAT_SINGLEQUOTE = "yaml.format.singleQuote";
    public static final String YAML_PREFERENCES_FORMAT_BRACKETSPACING = "yaml.format.bracketSpacing";
    public static final String YAML_PREFERENCES_FORMAT_PROSEWRAP = "yaml.format.proseWrap";
    public static final String YAML_PREFERENCES_FORMAT_PRINTWIDTH = "yaml.format.printWidth";
    public static final String YAML_PREFERENCES_HOVER = "yaml.hover";
    public static final String YAML_PREFERENCES_VALIDATE = "yaml.validate";
    public static final String YAML_PREFERENCES_YAMLVERSION = "yaml.yamlVersion";
    public static final String YAML_PREFERENCES_DISABLEADDITIONALPROPERTIES = "yaml.disableAdditionalProperties";
    public static final String YAML_PREFERENCES_CUSTOMTAGS = "yaml.customTags";
    public static final String YAML_PREFERENCES_STYLE_FLOWMAPPING = "yaml.style.flowMapping";
    public static final String YAML_PREFERENCES_STYLE_FLOWSEQUENCE = "yaml.style.flowSequence";

    public static Settings getGlobalSettings() {
        Settings settings = new Settings(YAMLPreferenceServerConstants.getPreferenceStore());
        settings.fillSetting(YAML_PREFERENCES_SCHEMAS, YAMLPreferenceServerConstants.getSchemaAssociations(Activator.getDefault().getPreferenceStore()));
        settings.fillAsBoolean(YAML_PREFERENCES_SCHEMASTORE_ENABLE);
        settings.fillAsString(YAML_PREFERENCES_SCHEMASTORE_URL);
        settings.fillAsInt(YAML_PREFERENCES_MAXITEMSCOMPUTED);
        settings.fillAsBoolean(YAML_PREFERENCES_COMPLETION);
        settings.fillAsBoolean(YAML_PREFERENCES_SUGGEST_PARENTSKELETONSELECTEDFIRST);
        settings.fillAsBoolean(YAML_PREFERENCES_DISABLEDEFAULTPROPERTIES);
        settings.fillAsBoolean(YAML_PREFERENCES_FORMAT_ENABLE);
        settings.fillAsBoolean(YAML_PREFERENCES_FORMAT_SINGLEQUOTE);
        settings.fillAsBoolean(YAML_PREFERENCES_FORMAT_BRACKETSPACING);
        settings.fillAsString(YAML_PREFERENCES_FORMAT_PROSEWRAP);
        settings.fillAsInt(YAML_PREFERENCES_FORMAT_PRINTWIDTH);
        settings.fillAsBoolean(YAML_PREFERENCES_HOVER);
        settings.fillAsBoolean(YAML_PREFERENCES_VALIDATE);
        settings.fillAsString(YAML_PREFERENCES_YAMLVERSION);
        settings.fillAsStringArray(YAML_PREFERENCES_CUSTOMTAGS, ",");
        settings.fillAsBoolean(YAML_PREFERENCES_DISABLEADDITIONALPROPERTIES);
        settings.fillAsString(YAML_PREFERENCES_STYLE_FLOWMAPPING);
        settings.fillAsString(YAML_PREFERENCES_STYLE_FLOWSEQUENCE);
        return settings;
    }

    public static void initializeDefaultPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        store.setDefault(YAML_PREFERENCES_SCHEMASTORE_ENABLE, true);
        store.setDefault(YAML_PREFERENCES_SCHEMASTORE_URL, "https://www.schemastore.org/api/json/catalog.json");
        store.setDefault(YAML_PREFERENCES_MAXITEMSCOMPUTED, 5000);
        store.setDefault(YAML_PREFERENCES_COMPLETION, true);
        store.setDefault(YAML_PREFERENCES_SUGGEST_PARENTSKELETONSELECTEDFIRST, false);
        store.setDefault(YAML_PREFERENCES_DISABLEDEFAULTPROPERTIES, false);
        store.setDefault(YAML_PREFERENCES_FORMAT_ENABLE, true);
        store.setDefault(YAML_PREFERENCES_FORMAT_SINGLEQUOTE, false);
        store.setDefault(YAML_PREFERENCES_FORMAT_BRACKETSPACING, true);
        store.setDefault(YAML_PREFERENCES_FORMAT_PROSEWRAP, "preserve");
        store.setDefault(YAML_PREFERENCES_FORMAT_PRINTWIDTH, 80);
        store.setDefault(YAML_PREFERENCES_HOVER, true);
        store.setDefault(YAML_PREFERENCES_VALIDATE, true);
        store.setDefault(YAML_PREFERENCES_YAMLVERSION, "1.2");
        store.setDefault(YAML_PREFERENCES_CUSTOMTAGS, "");
        store.setDefault(YAML_PREFERENCES_DISABLEADDITIONALPROPERTIES, false);
        store.setDefault(YAML_PREFERENCES_STYLE_FLOWMAPPING, "allow");
        store.setDefault(YAML_PREFERENCES_STYLE_FLOWSEQUENCE, "allow");
    }

    public static boolean isMatchYamlSection(String section) {
        return Settings.isMatchSection(section, YAML_SECTION);
    }

    private static Map<String, Object> getSchemaAssociations(IPreferenceStore preferenceStore) {
        IConfigurationElement[] conf;
        String schemaString = preferenceStore.getString("wildwebdeveloper.yaml.schema");
        Map contentTypeAssociations = (Map)new Gson().fromJson(schemaString, new TypeToken<HashMap<String, String>>(){}.getType());
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType yamlBaseContentType = contentTypeManager.getContentType("org.eclipse.wildwebdeveloper.yaml");
        HashMap<String, Object> associations = new HashMap<String, Object>();
        contentTypeAssociations.forEach((key, value) -> {
            IContentType contentType = contentTypeManager.getContentType(key);
            if (contentType != null && contentType.getBaseType().equals(yamlBaseContentType)) {
                String[] fileExtensions;
                String[] filePatterns;
                String[] fileNames;
                String[] stringArray = fileNames = contentType.getFileSpecs(4);
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    associations.put(value.toString(), fileName);
                    ++n2;
                }
                String[] stringArray2 = filePatterns = contentType.getFileSpecs(16);
                int n3 = filePatterns.length;
                n = 0;
                while (n < n3) {
                    String pattern = stringArray2[n];
                    associations.put(value.toString(), pattern);
                    ++n;
                }
                String[] stringArray3 = fileExtensions = contentType.getFileSpecs(8);
                int n4 = fileExtensions.length;
                n3 = 0;
                while (n3 < n4) {
                    String extension = stringArray3[n3];
                    associations.put(value.toString(), "*." + extension);
                    ++n3;
                }
            }
        });
        IConfigurationElement[] iConfigurationElementArray = conf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wildwebdeveloper.json.schema");
        int n = conf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String url = el.getAttribute("url");
            String pattern = el.getAttribute("pattern");
            if (!url.isBlank() && !pattern.isBlank()) {
                associations.put(SchemaAssociationRegistry.translate(url), pattern);
            }
            ++n2;
        }
        return associations;
    }

    public static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }
}

