/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.autoclose;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.XMLLanguageServerAPI;

public class XMLAutoCloseTagReconciler
implements IReconciler {
    private IDocument document;
    private ITextViewer viewer;
    private Listener listener;

    private static int getReplaceLength(Range range, IDocument document) throws BadLocationException {
        if (range == null) {
            return 0;
        }
        Position start = range.getStart();
        Position end = range.getEnd();
        if (start.getLine() == end.getLine()) {
            return end.getCharacter() - start.getCharacter();
        }
        int startOffset = LSPEclipseUtils.toOffset((Position)start, (IDocument)document);
        int endOffset = LSPEclipseUtils.toOffset((Position)end, (IDocument)document);
        return endOffset - startOffset;
    }

    public void install(ITextViewer viewer) {
        this.viewer = viewer;
        this.listener = new Listener();
        viewer.addTextInputListener((ITextInputListener)this.listener);
    }

    public void uninstall() {
        if (this.listener != null) {
            this.viewer.removeTextInputListener((ITextInputListener)this.listener);
            if (this.document != null) {
                this.document.removeDocumentListener((IDocumentListener)this.listener);
            }
            this.listener = null;
        }
        this.viewer = null;
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    static /* synthetic */ int access$0(Range range, IDocument iDocument) throws BadLocationException {
        return XMLAutoCloseTagReconciler.getReplaceLength(range, iDocument);
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            this.autoInsert(e);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == XMLAutoCloseTagReconciler.this.document) {
                if (XMLAutoCloseTagReconciler.this.document != null) {
                    XMLAutoCloseTagReconciler.this.document.removeDocumentListener((IDocumentListener)this);
                }
                XMLAutoCloseTagReconciler.this.document = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            XMLAutoCloseTagReconciler.this.document = newInput;
            if (XMLAutoCloseTagReconciler.this.document == null) {
                return;
            }
            XMLAutoCloseTagReconciler.this.document.addDocumentListener((IDocumentListener)this);
        }

        private void autoInsert(DocumentEvent event) {
            if (!this.isEnabled()) {
                return;
            }
            if (event == null || XMLAutoCloseTagReconciler.this.viewer == null) {
                return;
            }
            IDocument document = event.getDocument();
            if (document == null || event == null || event.getLength() != 0 || event.getText().length() != 1) {
                return;
            }
            int offset = event.getOffset() + 1;
            char c = event.getText().charAt(0);
            if (c != '>' && c != '/') {
                return;
            }
            URI uri = LSPEclipseUtils.toUri((IDocument)document);
            if (uri == null) {
                return;
            }
            TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
            LanguageServers.forDocument((IDocument)document).collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().filter(XMLLanguageServerAPI.class::isInstance).map(XMLLanguageServerAPI.class::cast).findAny().ifPresent(info -> {
                Display display = XMLAutoCloseTagReconciler.this.viewer.getTextWidget().getDisplay();
                CompletableFuture.supplyAsync(() -> {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Thread.interrupted();
                    }
                    try {
                        TextDocumentPositionParams params = LSPEclipseUtils.toTextDocumentPosistionParams((URI)uri, (int)offset, (IDocument)document);
                        info.closeTag(params).thenAccept(r -> {
                            if (r != null) {
                                display.asyncExec(() -> {
                                    try {
                                        String text = autoCloseTagResponse.snippet.replace("$0", "");
                                        int replaceLength = XMLAutoCloseTagReconciler.getReplaceLength(autoCloseTagResponse.range, document);
                                        document.replace(offset, replaceLength, text);
                                    }
                                    catch (BadLocationException badLocationException) {
                                        // empty catch block
                                    }
                                });
                            }
                        });
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    return null;
                });
            }));
        }

        private boolean isEnabled() {
            return Activator.getDefault().getPreferenceStore().getBoolean("completion/autoCloseTags");
        }
    }
}

