/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.services.LogThrottle;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.IEvaluationReference;
import org.osgi.service.log.LogLevel;

public class EvaluationReference
extends RunAndTrack
implements IEvaluationReference {
    private static final int THROTTLE_MAX = 100;
    private static final int THROTTLE_VALUE = 3;
    final IEclipseContext context;
    final Expression expression;
    final IPropertyChangeListener listener;
    final String property;
    final int sourcePriority;
    boolean cache;
    boolean participating = true;
    boolean postingChanges = true;
    boolean hasRun = false;
    static LogThrottle logThrottle = new LogThrottle(100, 3);

    public EvaluationReference(IEclipseContext context, Expression expression, IPropertyChangeListener listener, String property) {
        this.context = context;
        this.expression = expression;
        this.listener = listener;
        this.property = property;
        this.sourcePriority = SourcePriorityNameMapping.computeSourcePriority(expression);
    }

    @Override
    public void clearResult() {
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public int getSourcePriority() {
        return this.sourcePriority;
    }

    @Override
    public boolean evaluate(IEvaluationContext context) {
        if (this.expression == null) {
            this.cache = true;
        } else {
            try {
                this.cache = this.expression.evaluate(context) != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                String message = "Failed to evaluate: " + this.expression;
                boolean logged = logThrottle.log(LogLevel.ERROR.ordinal(), message, e);
                if (!logged && Policy.DEBUG_CMDS) {
                    Activator.trace((String)"/trace/commands", (String)message, (Throwable)e);
                }
                return false;
            }
        }
        return this.cache;
    }

    @Override
    public void setResult(boolean result) {
        this.cache = result;
    }

    public boolean changed(IEclipseContext context) {
        if (!this.participating) {
            return false;
        }
        this.evaluate();
        return this.participating;
    }

    public void evaluate() {
        boolean value = this.cache;
        this.evaluate((IEvaluationContext)new ExpressionContext(this.context));
        if (!this.postingChanges) {
            return;
        }
        if (!this.hasRun) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), null, (Object)this.cache));
        } else if (!this.participating) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), (Object)value, null));
        }
        if (value != this.cache) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), (Object)value, (Object)this.cache));
        }
        this.hasRun = true;
    }

    @Override
    public IPropertyChangeListener getListener() {
        return this.listener;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    public void setPostingChanges(boolean b) {
        this.postingChanges = b;
    }

    public boolean isPostingChanges() {
        return this.postingChanges;
    }
}

