/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.text.Collator;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class RepositoryTreeNodeSorter
extends ViewerSorter {
    public RepositoryTreeNodeSorter() {
        this(null);
    }

    public RepositoryTreeNodeSorter(Collator collator) {
        super(collator);
    }

    public int category(Object element) {
        if (element instanceof RepositoryTreeNode) {
            RepositoryTreeNode node = (RepositoryTreeNode)element;
            RepositoryTreeNodeType type = node.getType();
            switch (type) {
                case REPOGROUP: {
                    return RepositoryTreeNodeType.values().length;
                }
                case BRANCHHIERARCHY: {
                    return RepositoryTreeNodeType.REF.ordinal();
                }
            }
            return type.ordinal();
        }
        return super.category(element);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int category2;
        int category1 = this.category(e1);
        if (category1 != (category2 = this.category(e2))) {
            return category1 - category2;
        }
        if (e1 instanceof RepositoryTreeNode && e2 instanceof RepositoryTreeNode) {
            RepositoryTreeNode node1 = (RepositoryTreeNode)e1;
            RepositoryTreeNode node2 = (RepositoryTreeNode)e2;
            return node1.compareTo(node2);
        }
        return super.compare(viewer, e1, e2);
    }
}

