/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.credentials.UserPasswordCredentials;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.push.PushResultTable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class ConfirmationPage
extends WizardPage {
    private final Repository local;
    private RepositorySelection displayedRepoSelection;
    private List<RefSpec> displayedRefSpecs;
    private PushOperationResult confirmedResult;
    private PushResultTable resultPanel;
    private Button requireUnchangedButton;
    private Button showOnlyIfChanged;
    private UserPasswordCredentials credentials;
    private String helpContext = null;

    public ConfirmationPage(Repository local) {
        super(ConfirmationPage.class.getName());
        this.local = local;
        this.setTitle(UIText.ConfirmationPage_title);
        this.setDescription(UIText.ConfirmationPage_description);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        this.resultPanel = new PushResultTable(panel);
        Control tableControl = this.resultPanel.getControl();
        tableControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.requireUnchangedButton = new Button(panel, 32);
        this.requireUnchangedButton.setText(UIText.ConfirmationPage_requireUnchangedButton);
        this.showOnlyIfChanged = new Button(panel, 32);
        this.showOnlyIfChanged.setText(UIText.ConfirmationPage_showOnlyIfChanged);
        Dialog.applyDialogFont((Control)panel);
        this.setControl((Control)panel);
    }

    public void setSelection(RepositorySelection repositorySelection, List<RefSpec> specSelection) {
        this.checkPreviousPagesSelections(repositorySelection, specSelection);
        this.revalidate(repositorySelection, specSelection);
    }

    public void setCredentials(UserPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public void setHelpContext(String id) {
        this.helpContext = id;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.helpContext);
    }

    boolean isConfirmed() {
        return this.confirmedResult != null;
    }

    PushOperationResult getConfirmedResult() {
        return this.confirmedResult;
    }

    boolean isRequireUnchangedSelected() {
        return this.requireUnchangedButton != null && this.requireUnchangedButton.getSelection();
    }

    boolean isShowOnlyIfChangedSelected() {
        return this.showOnlyIfChanged != null && this.showOnlyIfChanged.getSelection();
    }

    private void checkPreviousPagesSelections(RepositorySelection repositorySelection, List<RefSpec> refSpecs) {
        if (!repositorySelection.equals(this.displayedRepoSelection) || !refSpecs.equals(this.displayedRefSpecs)) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(this.confirmedResult != null);
        }
    }

    private void revalidate(RepositorySelection repositorySelection, List<RefSpec> refSpecs) {
        this.resultPanel.setData(this.local, null);
        this.confirmedResult = null;
        this.displayedRepoSelection = repositorySelection;
        this.displayedRefSpecs = refSpecs;
        this.setErrorMessage(null);
        this.setPageComplete(false);
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConfirmationPage.this.revalidateImpl();
            }
        });
    }

    private void revalidateImpl() {
        PushOperation operation;
        if (this.getControl().isDisposed() || !this.isCurrentPage()) {
            return;
        }
        List fetchSpecs = this.displayedRepoSelection.isConfigSelected() ? this.displayedRepoSelection.getConfig().getFetchRefSpecs() : null;
        try {
            Collection updates = Transport.findRemoteRefUpdatesFor((Repository)this.local, this.displayedRefSpecs, (Collection)fetchSpecs);
            if (updates.isEmpty()) {
                this.setErrorMessage(UIText.ConfirmationPage_errorRefsChangedNoMatch);
                this.setPageComplete(false);
                return;
            }
            PushOperationSpecification spec = new PushOperationSpecification();
            for (URIish uri : this.displayedRepoSelection.getPushURIs()) {
                spec.addURIRefUpdates(uri, PushOperationSpecification.copyUpdates((Collection)updates, (boolean)false));
            }
            operation = new PushOperation(this.local, spec, true, GitSettings.getRemoteConnectionTimeout());
            if (this.credentials != null) {
                operation.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider(this.credentials.getUser(), this.credentials.getPassword()));
            }
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    operation.run(monitor);
                }
            });
        }
        catch (IOException e) {
            this.setErrorMessage(NLS.bind((String)UIText.ConfirmationPage_errorCantResolveSpecs, (Object)e.getMessage()));
            return;
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(NLS.bind((String)UIText.ConfirmationPage_errorUnexpected, (Object)e.getCause().getMessage()));
            return;
        }
        catch (InterruptedException e) {
            this.setErrorMessage(UIText.ConfirmationPage_errorInterrupted);
            this.setPageComplete(true);
            this.displayedRefSpecs = null;
            this.displayedRepoSelection = null;
            return;
        }
        PushOperationResult result = operation.getOperationResult();
        this.resultPanel.setData(this.local, result);
        if (result.isSuccessfulConnectionForAnyURI()) {
            this.setPageComplete(true);
            this.confirmedResult = result;
        } else {
            String message = NLS.bind((String)UIText.ConfirmationPage_cantConnectToAny, (Object)result.getErrorStringForAllURis());
            this.setErrorMessage(message);
            ErrorDialog.openError((Shell)this.getShell(), (String)UIText.ConfirmationPage_cantConnectToAnyTitle, null, (IStatus)new Status(4, "org.eclipse.egit.ui", message));
        }
    }
}

