/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.text.MessageFormat;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.internal.storage.IndexFileRevision;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;

public class GitCompareLabelProvider
extends BaseLabelProvider
implements ICompareInputLabelProvider {
    private boolean isEditable(Object object) {
        if (object instanceof IEditableContent) {
            return ((IEditableContent)object).isEditable();
        }
        return false;
    }

    private String getLabel(FileRevisionTypedElement element) {
        if (element == null) {
            return null;
        }
        IFileRevision fileObject = element.getFileRevision();
        if (fileObject instanceof IndexFileRevision) {
            if (this.isEditable(element)) {
                return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_IndexEditableLabel, element.getName());
            }
            return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_IndexLabel, element.getName());
        }
        return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_RevisionLabel, element.getName(), CompareUtils.truncatedRevision(element.getContentIdentifier()), element.getAuthor());
    }

    private IResource getResource(ITypedElement element) {
        if (element instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)element;
            return resourceProvider.getResource();
        }
        return null;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }

    public String getAncestorLabel(Object input) {
        ITypedElement item;
        if (input instanceof DiffNode && (item = ((DiffNode)input).getAncestor()) instanceof FileRevisionTypedElement) {
            return this.getLabel((FileRevisionTypedElement)item);
        }
        return null;
    }

    public Image getAncestorImage(Object input) {
        return null;
    }

    public String getLeftLabel(Object input) {
        if (input instanceof DiffNode) {
            ITypedElement item = ((DiffNode)input).getLeft();
            if (item instanceof FileRevisionTypedElement) {
                return this.getLabel((FileRevisionTypedElement)item);
            }
            if (this.getResource(item) != null) {
                return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_LocalLabel, item.getName());
            }
        }
        return null;
    }

    public Image getLeftImage(Object input) {
        return null;
    }

    public String getRightLabel(Object input) {
        if (input instanceof DiffNode) {
            ITypedElement item = ((DiffNode)input).getRight();
            if (item instanceof FileRevisionTypedElement) {
                return this.getLabel((FileRevisionTypedElement)item);
            }
            if (this.getResource(item) != null) {
                return MessageFormat.format(UIText.GitCompareFileRevisionEditorInput_LocalLabel, item.getName());
            }
        }
        return null;
    }

    public Image getRightImage(Object input) {
        return null;
    }

    public void fireNodeLabelChanged(Object object) {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, object);
        this.fireLabelProviderChanged(event);
    }
}

