/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CancelableFuture;
import org.eclipse.egit.ui.internal.dialogs.NonBlockingWizardDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class AsynchronousRefProposalProvider
implements UIUtils.IContentProposalCandidateProvider<Ref> {
    private final IWizardContainer container;
    private final Text textField;
    private final Supplier<String> uriProvider;
    private final Function<String, CancelableFuture<Collection<Ref>>> listProvider;
    private UIUtils.ExplicitContentProposalAdapter contentProposer;

    public AsynchronousRefProposalProvider(IWizardContainer container, Text textField, Supplier<String> uriProvider, Function<String, CancelableFuture<Collection<Ref>>> listProvider) {
        this.container = container;
        this.textField = textField;
        this.uriProvider = uriProvider;
        this.listProvider = listProvider;
    }

    public void setContentProposalAdapter(UIUtils.ExplicitContentProposalAdapter adapter) {
        this.contentProposer = adapter;
    }

    @Override
    public Collection<? extends Ref> getCandidates() {
        CancelableFuture<Collection<Ref>> list;
        block6: {
            final String uri = this.uriProvider.get();
            if (uri == null) {
                return null;
            }
            list = this.listProvider.apply(uri);
            if (list.isFinished()) break block6;
            IRunnableWithProgress operation = monitor -> {
                monitor.beginTask(MessageFormat.format(UIText.AsynchronousRefProposalProvider_FetchingRemoteRefsMessage, uri), -1);
                Collection result = (Collection)list.get();
                if (monitor.isCanceled()) {
                    return;
                }
                if (result == null || result.isEmpty()) {
                    return;
                }
                WorkbenchJob showProposals = new WorkbenchJob(UIText.AsynchronousRefProposalProvider_ShowingProposalsJobName){

                    public boolean shouldRun() {
                        return super.shouldRun() && AsynchronousRefProposalProvider.this.contentProposer != null;
                    }

                    public IStatus runInUIThread(IProgressMonitor uiMonitor) {
                        try {
                            if (AsynchronousRefProposalProvider.this.container instanceof NonBlockingWizardDialog) {
                                if (AsynchronousRefProposalProvider.this.textField.isDisposed() || !AsynchronousRefProposalProvider.this.textField.isVisible() || AsynchronousRefProposalProvider.this.textField != AsynchronousRefProposalProvider.this.textField.getDisplay().getFocusControl()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                String uriNow = AsynchronousRefProposalProvider.this.uriProvider.get();
                                if (!uriNow.equals(uri)) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                            }
                            try {
                                AsynchronousRefProposalProvider.this.contentProposer.openProposalPopup();
                            }
                            catch (SWTException e) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                        }
                        finally {
                            uiMonitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                showProposals.schedule();
            };
            if (this.container instanceof NonBlockingWizardDialog) {
                NonBlockingWizardDialog dialog = (NonBlockingWizardDialog)this.container;
                dialog.run(operation, () -> {
                    boolean bl = list.cancel(CancelableFuture.CancelMode.ABANDON);
                });
            } else {
                this.container.run(true, true, operation);
            }
            return null;
        }
        try {
            return list.get();
        }
        catch (InterruptedException | InvocationTargetException e) {
            return null;
        }
    }
}

