/// <reference types="node" />
import { Handles } from 'vscode-debugadapter';
import * as https from 'https';
import { IExecutionResultTelemetryProperties } from './telemetry';
export interface IStringDictionary<T> {
    [name: string]: T;
}
export declare const enum Platform {
    Windows = 0,
    OSX = 1,
    Linux = 2,
}
export declare function getPlatform(): Platform;
/**
 * Node's fs.existsSync is deprecated, implement it in terms of statSync
 */
export declare function existsSync(path: string): boolean;
/**
 * Node's fs.exists is deprecated, implement it in terms of stat
 */
export declare function exists(path: string): Promise<boolean>;
/**
 * Checks asynchronously if a path exists on the disk.
 */
export declare function existsAsync(path: string): Promise<boolean>;
/**
 * Returns a reversed version of arr. Doesn't modify the input.
 */
export declare function reversedArr(arr: any[]): any[];
export declare function promiseTimeout(p?: Promise<any>, timeoutMs?: number, timeoutMsg?: string): Promise<any>;
export declare function retryAsync(fn: () => Promise<any>, timeoutMs: number, intervalDelay?: number): Promise<any>;
export declare function setCaseSensitivePaths(useCaseSensitivePaths: boolean): void;
/**
 * Modify a url/path either from the client or the target to a common format for comparing.
 * The client can handle urls in this format too.
 * file:///D:\\scripts\\code.js => d:/scripts/code.js
 * file:///Users/me/project/code.js => /Users/me/project/code.js
 * c:/scripts/code.js => c:\\scripts\\code.js
 * http://site.com/scripts/code.js => (no change)
 * http://site.com/ => http://site.com
 */
export declare function canonicalizeUrl(urlOrPath: string): string;
export declare function isFileUrl(candidate: string): boolean;
/**
 * If urlOrPath is a file URL, removes the 'file:///', adjusting for platform differences
 */
export declare function fileUrlToPath(urlOrPath: string): string;
export declare function fileUrlToNetworkPath(urlOrPath: string): string;
/**
 * Replace any backslashes with forward slashes
 * blah\something => blah/something
 */
export declare function forceForwardSlashes(aUrl: string): string;
/**
 * Ensure lower case drive letter and \ on Windows
 */
export declare function fixDriveLetterAndSlashes(aPath: string, uppercaseDriveLetter?: boolean): string;
export declare function fixDriveLetter(aPath: string, uppercaseDriveLetter?: boolean): string;
/**
 * Remove a slash of any flavor from the end of the path
 */
export declare function stripTrailingSlash(aPath: string): string;
/**
 * A helper for returning a rejected promise with an Error object. Avoids double-wrapping an Error, which could happen
 * when passing on a failure from a Promise error handler.
 * @param msg - Should be either a string or an Error
 */
export declare function errP(msg: string | Error): Promise<never>;
/**
 * Helper function to GET the contents of a url
 */
export declare function getURL(aUrl: string, options?: https.RequestOptions): Promise<string>;
/**
 * Returns true if urlOrPath is like "http://localhost" and not like "c:/code/file.js" or "/code/file.js"
 */
export declare function isURL(urlOrPath: string): boolean;
export declare function isAbsolute(_path: string): boolean;
/**
 * Strip a string from the left side of a string
 */
export declare function lstrip(s: string, lStr: string): string;
/**
 * Convert a local path to a file URL, like
 * C:/code/app.js => file:///C:/code/app.js
 * /code/app.js => file:///code/app.js
 * \\code\app.js => file:///code/app.js
 */
export declare function pathToFileURL(_absPath: string, normalize?: boolean): string;
export declare function fsReadDirP(path: string): Promise<string[]>;
export declare function readFileP(path: string, encoding?: string): Promise<string>;
export declare function writeFileP(filePath: string, data: string): Promise<string>;
/**
 * Make sure that all directories of the given path exist (like mkdir -p).
 */
export declare function mkdirs(dirsPath: string): void;
export declare function extendObject<T>(objectCopy: T, object: T): T;
export declare function multiGlob(patterns: string[], opts?: any): Promise<string[]>;
/**
 * A reversable subclass of the Handles helper
 */
export declare class ReverseHandles<T> extends Handles<T> {
    private _reverseMap;
    create(value: T): number;
    lookup(value: T): number;
    lookupF(idFn: (value: T) => boolean): number;
    set(handle: number, value: T): void;
}
/**
 * Return a regex for the given path to set a breakpoint on
 */
export declare function pathToRegex(aPath: string): string;
export declare function pathGlobToBlackboxedRegex(glob: string): string;
export declare function escapeRegexSpecialChars(str: string, except?: string): string;
export declare function trimLastNewline(str: string): string;
export declare function prettifyNewlines(str: string): string;
export declare function makeRegexNotMatchPath(regex: RegExp, aPath: string): RegExp;
export declare function makeRegexMatchPath(regex: RegExp, aPath: string): RegExp;
export declare function uppercaseFirstLetter(str: string): string;
export declare function getLine(msg: string, n?: number): string;
export declare function firstLine(msg: string): string;
export declare function isNumber(num: number): boolean;
export declare function toVoidP(p: Promise<any>): Promise<void>;
export interface PromiseDefer<T> {
    promise: Promise<void>;
    resolve: (value?: T | PromiseLike<T>) => void;
    reject: (reason?: any) => void;
}
export declare function promiseDefer<T>(): PromiseDefer<T>;
export declare type HighResTimer = [number, number];
export declare function calculateElapsedTime(startProcessingTime: HighResTimer): number;
export declare function fillErrorDetails(properties: IExecutionResultTelemetryProperties, e: any): void;
/**
 * Join path segments properly based on whether they appear to be c:/ -style or / style.
 * Note - must check posix first because win32.isAbsolute includes posix.isAbsolute
 */
export declare function properJoin(...segments: string[]): string;
export declare function properResolve(...segments: string[]): string;
