/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import com.google.gson.Gson;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.node.AttachTab;

public class NodeAttachDebugTab
extends AttachTab {
    private Text localRootText;
    private Text remoteRootText;

    public NodeAttachDebugTab() {
        super(9229);
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        Composite rootMapComposite = new Composite(composite, 0);
        GridDataFactory.swtDefaults().align(4, 1).span(((GridLayout)composite.getLayout()).numColumns, 1).grab(true, false).indent(0, 40).applyTo((Control)rootMapComposite);
        rootMapComposite.setLayout((Layout)new GridLayout(3, false));
        Label rootMapDescription = new Label(rootMapComposite, 0);
        rootMapDescription.setText(Messages.NodeAttach_rootMapDescription);
        rootMapDescription.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        GridDataFactory indentFactory = GridDataFactory.swtDefaults().indent(20, 0);
        Label remoteRootLabel = new Label(rootMapComposite, 0);
        remoteRootLabel.setText(Messages.NodeAttach_remoteRoot);
        indentFactory.applyTo((Control)remoteRootLabel);
        this.remoteRootText = new Text(rootMapComposite, 2048);
        this.remoteRootText.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.remoteRootText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Label localRootLabel = new Label(rootMapComposite, 0);
        localRootLabel.setText(Messages.NodeAttach_localRoot);
        indentFactory.applyTo((Control)localRootLabel);
        this.localRootText = new Text(rootMapComposite, 2048);
        this.localRootText.setLayoutData((Object)new GridData(4, -1, true, false));
        Button browseLocalButton = new Button(rootMapComposite, 8);
        browseLocalButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        browseLocalButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog directoryDialog = new DirectoryDialog(browseLocalButton.getShell());
            directoryDialog.setText(Messages.NodeAttach_localRoot);
            String selectedDirString = directoryDialog.open();
            if (selectedDirString != null) {
                this.localRootText.setText(selectedDirString);
            }
        }));
        ControlDecoration invalidDirectoryDecoration = new ControlDecoration((Control)this.localRootText, 16512);
        invalidDirectoryDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING").getImage());
        invalidDirectoryDecoration.setDescriptionText(Messages.NodeAttach_invalidLocalRootDirectory);
        invalidDirectoryDecoration.hide();
        this.localRootText.addModifyListener(e -> {
            if (!this.localRootText.getText().isEmpty() && !new File(this.localRootText.getText()).isDirectory()) {
                invalidDirectoryDecoration.show();
                this.setWarningMessage(Messages.NodeAttach_invalidLocalRootDirectory);
            } else {
                invalidDirectoryDecoration.hide();
                this.setWarningMessage(null);
            }
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String localRoot;
            Map map = (Map)new Gson().fromJson(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_PARAM", ""), Map.class);
            if (map == null) {
                map = Collections.emptyMap();
            }
            if (!(localRoot = configuration.getAttribute("localRoot", "")).isEmpty()) {
                this.localRootText.setText(localRoot);
            } else if (map.containsKey("localRoot")) {
                this.localRootText.setText(map.get("localRoot").toString());
            }
            String remoteRoot = configuration.getAttribute("remoteRoot", "");
            if (!localRoot.isEmpty()) {
                this.remoteRootText.setText(remoteRoot);
            } else if (map.containsKey("remoteRoot")) {
                this.remoteRootText.setText(map.get("remoteRoot").toString());
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        if (!this.localRootText.getText().isEmpty()) {
            configuration.setAttribute("localRoot", this.localRootText.getText());
        }
        if (!this.remoteRootText.getText().isEmpty()) {
            configuration.setAttribute("remoteRoot", this.remoteRootText.getText());
        }
    }
}

