/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.preferences;

import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.registry.WorkingCopyGrammarRegistryManager;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.TMUIMessages;
import org.eclipse.tm4e.ui.internal.themes.WorkingCopyThemeManager;
import org.eclipse.tm4e.ui.internal.widgets.ColumnSelectionAdapter;
import org.eclipse.tm4e.ui.internal.widgets.ColumnViewerComparator;
import org.eclipse.tm4e.ui.internal.widgets.ContentTypesBindingWidget;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionContentProvider;
import org.eclipse.tm4e.ui.internal.widgets.GrammarDefinitionLabelProvider;
import org.eclipse.tm4e.ui.internal.widgets.GrammarInfoWidget;
import org.eclipse.tm4e.ui.internal.widgets.TMViewer;
import org.eclipse.tm4e.ui.internal.widgets.ThemeAssociationsWidget;
import org.eclipse.tm4e.ui.internal.wizards.TextMateGrammarImportWizard;
import org.eclipse.tm4e.ui.snippets.ISnippet;
import org.eclipse.tm4e.ui.snippets.ISnippetManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public final class GrammarPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.ui.preferences.GrammarPreferencePage";
    private IGrammarRegistryManager grammarRegistryManager = new WorkingCopyGrammarRegistryManager(TMEclipseRegistryPlugin.getGrammarRegistryManager());
    private IThemeManager themeManager = new WorkingCopyThemeManager(TMUIPlugin.getThemeManager());
    private ISnippetManager snippetManager = TMUIPlugin.getSnippetManager();
    private TableViewer grammarViewer = (TableViewer)NullSafetyHelper.lazyNonNull();
    private Button grammarRemoveButton = (Button)NullSafetyHelper.lazyNonNull();
    private GrammarInfoWidget grammarInfoWidget = (GrammarInfoWidget)((Object)NullSafetyHelper.lazyNonNull());
    private ContentTypesBindingWidget contentTypesWidget = (ContentTypesBindingWidget)((Object)NullSafetyHelper.lazyNonNull());
    private ThemeAssociationsWidget themeAssociationsWidget = (ThemeAssociationsWidget)((Object)NullSafetyHelper.lazyNonNull());
    private TMViewer previewViewer = (TMViewer)((Object)NullSafetyHelper.lazyNonNull());

    public GrammarPreferencePage() {
        this.setDescription(TMUIMessages.GrammarPreferencePage_description);
    }

    IGrammarRegistryManager getGrammarRegistryManager() {
        return this.grammarRegistryManager;
    }

    void setGrammarRegistryManager(IGrammarRegistryManager grammarRegistryManager) {
        this.grammarRegistryManager = grammarRegistryManager;
    }

    IThemeManager getThemeManager() {
        return this.themeManager;
    }

    void setThemeManager(IThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    ISnippetManager getSnippetManager() {
        return this.snippetManager;
    }

    void setSnippetManager(ISnippetManager snippetManager) {
        this.snippetManager = snippetManager;
    }

    protected Control createContents(@Nullable Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        innerParent.setLayoutData((Object)gd);
        this.createGrammarListContent(innerParent);
        this.createGrammarDetailContent(innerParent);
        this.previewViewer = this.doCreateViewer(innerParent);
        this.grammarViewer.setInput((Object)this.grammarRegistryManager);
        this.updateButtons();
        Dialog.applyDialogFont((Control)parent);
        innerParent.layout();
        return parent;
    }

    private void createGrammarListContent(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.widthHint = 360;
        data.heightHint = this.convertHeightInCharsToPixels(10);
        tableComposite.setLayoutData((Object)data);
        TableColumnLayout columnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)columnLayout);
        Table table = new Table(tableComposite, 68358);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GC gc = new GC((Drawable)this.getShell());
        gc.setFont(JFaceResources.getDialogFont());
        ColumnViewerComparator viewerComparator = new ColumnViewerComparator();
        this.grammarViewer = new TableViewer(table);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(TMUIMessages.GrammarPreferencePage_column_scopeName);
        int minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.GrammarPreferencePage_column_scopeName);
        columnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column1, this.grammarViewer, 0, viewerComparator));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(TMUIMessages.GrammarPreferencePage_column_path);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.GrammarPreferencePage_column_path);
        columnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column2, this.grammarViewer, 1, viewerComparator));
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(TMUIMessages.GrammarPreferencePage_column_pluginId);
        minWidth = this.computeMinimumColumnWidth(gc, TMUIMessages.GrammarPreferencePage_column_pluginId);
        columnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(2, minWidth, true));
        column3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(column3, this.grammarViewer, 2, viewerComparator));
        gc.dispose();
        this.grammarViewer.setLabelProvider((IBaseLabelProvider)new GrammarDefinitionLabelProvider());
        this.grammarViewer.setContentProvider((IContentProvider)new GrammarDefinitionContentProvider());
        this.grammarViewer.setComparator((ViewerComparator)viewerComparator);
        this.grammarViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent e) {
                if (e == null) {
                    return;
                }
                IStructuredSelection selection = GrammarPreferencePage.this.grammarViewer.getStructuredSelection();
                if (selection.isEmpty()) {
                    return;
                }
                IGrammarDefinition definition = (IGrammarDefinition)selection.getFirstElement();
                GrammarPreferencePage.this.grammarRemoveButton.setEnabled(definition.getPluginId() == null);
                GrammarPreferencePage.this.themeAssociationsWidget.getNewButton().setEnabled(false);
                GrammarPreferencePage.this.themeAssociationsWidget.getRemoveButton().setEnabled(false);
                this.selectGrammar(definition);
            }

            private void selectGrammar(IGrammarDefinition definition) {
                String scopeName = definition.getScopeName();
                this.fillGeneralTab(scopeName);
                this.fillContentTypeTab(scopeName);
                IThemeAssociation selectedAssociation = this.fillThemeTab(definition);
                this.fillPreview(scopeName, selectedAssociation);
            }

            private void fillGeneralTab(String scopeName) {
                IGrammar grammar = GrammarPreferencePage.this.grammarRegistryManager.getGrammarForScope(scopeName);
                GrammarPreferencePage.this.grammarInfoWidget.refresh(grammar);
            }

            private void fillContentTypeTab(String scopeName) {
                GrammarPreferencePage.this.contentTypesWidget.setInput(GrammarPreferencePage.this.grammarRegistryManager.getContentTypesForScope(scopeName));
            }

            private @Nullable IThemeAssociation fillThemeTab(IGrammarDefinition definition) {
                IThemeAssociation selectedAssociation = null;
                IStructuredSelection oldSelection = GrammarPreferencePage.this.themeAssociationsWidget.getSelection();
                IThemeAssociation[] themeAssociations = GrammarPreferencePage.this.themeAssociationsWidget.setGrammarDefinition(definition);
                if (!oldSelection.isEmpty() && Arrays.asList(themeAssociations).contains(oldSelection.getFirstElement())) {
                    selectedAssociation = (IThemeAssociation)oldSelection.getFirstElement();
                    GrammarPreferencePage.this.themeAssociationsWidget.setSelection(oldSelection);
                } else {
                    IThemeAssociation iThemeAssociation = selectedAssociation = themeAssociations.length > 0 ? themeAssociations[0] : null;
                    if (selectedAssociation != null) {
                        GrammarPreferencePage.this.themeAssociationsWidget.setSelection((IStructuredSelection)new StructuredSelection((Object)selectedAssociation));
                    }
                }
                return selectedAssociation;
            }

            private void fillPreview(String scopeName, @Nullable IThemeAssociation selectedAssociation) {
                IGrammar grammar = GrammarPreferencePage.this.grammarRegistryManager.getGrammarForScope(scopeName);
                if (selectedAssociation != null) {
                    GrammarPreferencePage.this.setPreviewTheme(selectedAssociation.getThemeId());
                }
                GrammarPreferencePage.this.previewViewer.setGrammar(grammar);
                ISnippet[] snippets = GrammarPreferencePage.this.snippetManager.getSnippets(scopeName);
                if (snippets.length == 0) {
                    GrammarPreferencePage.this.previewViewer.setText("");
                } else {
                    GrammarPreferencePage.this.previewViewer.setText(snippets[0].getContent());
                }
            }
        });
        table.setSortColumn(column1);
        table.setSortDirection(viewerComparator.getDirection());
        BidiUtils.applyTextDirection((Control)this.grammarViewer.getControl(), (String)"default");
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        Button grammarNewButton = new Button(buttons, 8);
        grammarNewButton.setText(TMUIMessages.Button_new);
        grammarNewButton.setLayoutData((Object)new GridData(768));
        grammarNewButton.addListener(13, e -> {
            TextMateGrammarImportWizard wizard = new TextMateGrammarImportWizard(false);
            wizard.setGrammarRegistryManager(this.grammarRegistryManager);
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                IGrammarDefinition created = wizard.getCreatedDefinition();
                this.grammarViewer.refresh();
                this.grammarViewer.setSelection((ISelection)new StructuredSelection((Object)created));
            }
        });
        this.grammarRemoveButton = new Button(buttons, 8);
        this.grammarRemoveButton.setText(TMUIMessages.Button_remove);
        this.grammarRemoveButton.setLayoutData((Object)new GridData(768));
        this.grammarRemoveButton.addListener(13, e -> {
            IGrammarDefinition definition = (IGrammarDefinition)((IStructuredSelection)this.grammarViewer.getSelection()).getFirstElement();
            this.grammarRegistryManager.unregisterGrammarDefinition(definition);
            this.grammarViewer.refresh();
        });
    }

    private void createGrammarDetailContent(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        folder.setLayoutData((Object)gd);
        this.createGeneralTab(folder);
        this.createContentTypeTab(folder);
        this.createThemeTab(folder);
        this.createInjectionTab(folder);
    }

    private void createGeneralTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_general_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.grammarInfoWidget = new GrammarInfoWidget(parent, 0);
        this.grammarInfoWidget.setLayoutData(new GridData(768));
        tab.setControl((Control)parent);
    }

    private void createContentTypeTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_contentType_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.contentTypesWidget = new ContentTypesBindingWidget(parent, 0);
        this.contentTypesWidget.setLayoutData(new GridData(768));
        tab.setControl((Control)parent);
    }

    private void createThemeTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_theme_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        this.themeAssociationsWidget = new ThemeAssociationsWidget(this.themeManager, parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.themeAssociationsWidget.setLayoutData(data);
        this.themeAssociationsWidget.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(@Nullable SelectionChangedEvent e) {
                if (e == null) {
                    return;
                }
                IThemeAssociation association = (IThemeAssociation)((IStructuredSelection)e.getSelection()).getFirstElement();
                this.selectTheme(association);
            }

            private void selectTheme(@Nullable IThemeAssociation association) {
                GrammarPreferencePage.this.themeAssociationsWidget.getNewButton().setEnabled(association != null);
                GrammarPreferencePage.this.themeAssociationsWidget.getRemoveButton().setEnabled(association != null);
                if (association != null) {
                    GrammarPreferencePage.this.setPreviewTheme(association.getThemeId());
                }
            }
        });
        tab.setControl((Control)parent);
    }

    private void setPreviewTheme(String themeId) {
        ITheme theme = this.themeManager.getThemeById(themeId);
        if (theme != null) {
            this.previewViewer.setTheme(theme);
        }
    }

    private void createInjectionTab(TabFolder folder) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(TMUIMessages.GrammarPreferencePage_tab_injection_text);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(768));
        tab.setControl((Control)parent);
    }

    private int computeMinimumColumnWidth(GC gc, String string) {
        return gc.stringExtent((String)string).x + 10;
    }

    private void updateButtons() {
        this.grammarRemoveButton.setEnabled(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(TMUIMessages.GrammarPreferencePage_title);
        }
    }

    public void init(@Nullable IWorkbench workbench) {
    }

    private TMViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TMUIMessages.GrammarPreferencePage_preview);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        TMViewer viewer = this.createViewer(parent);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    private TMViewer createViewer(Composite parent) {
        return new TMViewer(parent, null, null, false, 2816);
    }

    public boolean performOk() {
        try {
            this.grammarRegistryManager.save();
            this.themeManager.save();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
            return false;
        }
        return super.performOk();
    }
}

