/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffContainer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.merge.AbstractGitCompareEditorInput;
import org.eclipse.egit.ui.internal.merge.GitCompareLabelProvider;
import org.eclipse.egit.ui.internal.merge.MergeDiffNode;
import org.eclipse.egit.ui.internal.revision.FileRevisionTypedElement;
import org.eclipse.egit.ui.internal.synchronize.compare.LocalNonWorkspaceTypedElement;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.synchronize.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public class GitCompareEditorInput
extends AbstractGitCompareEditorInput {
    private final String leftVersion;
    private final String rightVersion;

    public GitCompareEditorInput(String leftVersion, String rightVersion, Repository repository, IPath ... paths) {
        super(repository, paths);
        this.leftVersion = leftVersion;
        this.rightVersion = rightVersion;
    }

    @Override
    protected GitInfo getGitInfo(final IPath path) {
        return new GitInfo(){

            public Repository getRepository() {
                return GitCompareEditorInput.this.getRepository();
            }

            public String getGitPath() {
                return path.toString();
            }

            public GitInfo.Source getSource() {
                return GitCompareEditorInput.this.leftVersion == null ? GitInfo.Source.WORKING_TREE : GitInfo.Source.COMMIT;
            }

            public AnyObjectId getCommitId() {
                return null;
            }
        };
    }

    @Override
    protected DiffContainer buildInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Repository repo = this.getRepository();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk rw = new RevWalk(repo);){
                RevCommit leftCommit = this.leftVersion == null ? null : rw.parseCommit((AnyObjectId)repo.resolve(this.leftVersion));
                RevCommit rightCommit = rw.parseCommit((AnyObjectId)repo.resolve(this.rightVersion));
                CompareConfiguration config = this.getCompareConfiguration();
                config.setDefaultLabelProvider((ICompareInputLabelProvider)new GitCompareLabelProvider());
                if (this.leftVersion == null) {
                    config.setLeftLabel(UIText.GitCompareEditorInput_WorkingTreeFallbackLabel);
                } else {
                    config.setLeftLabel(this.leftVersion);
                }
                config.setRightLabel(this.rightVersion);
                this.setTitle(MessageFormat.format(UIText.GitCompareEditorInput_EditorTitle, RepositoryUtil.INSTANCE.getRepositoryName(repo), this.leftVersion == null ? UIText.GitCompareEditorInput_WorkingTreeSourceName : CompareUtils.truncatedRevision(this.leftVersion), CompareUtils.truncatedRevision(this.rightVersion)));
                return this.buildDiffContainer(leftCommit, rightCommit, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private DiffContainer buildDiffContainer(RevCommit leftCommit, RevCommit rightCommit, IProgressMonitor monitor) throws IOException, InterruptedException {
        DiffNode result = new DiffNode(12);
        Repository repo = this.getRepository();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TreeWalk tw = new TreeWalk(repo);){
            int leftIndex;
            int dirCacheIndex = -1;
            if (leftCommit == null) {
                FileTreeIterator fit = new FileTreeIterator(repo);
                leftIndex = tw.addTree((AbstractTreeIterator)fit);
                dirCacheIndex = tw.addTree((AbstractTreeIterator)new DirCacheIterator(repo.readDirCache()));
                fit.setDirCacheIterator(tw, dirCacheIndex);
            } else {
                leftIndex = tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repo.newObjectReader(), (AnyObjectId)leftCommit.getTree()));
            }
            int rightIndex = tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, repo.newObjectReader(), (AnyObjectId)rightCommit.getTree()));
            Collection<String> filterPaths = this.getFilterPaths();
            if (!filterPaths.isEmpty()) {
                if (filterPaths.size() > 1) {
                    tw.setFilter(PathFilterGroup.createFromStrings(filterPaths));
                } else {
                    String path = filterPaths.iterator().next();
                    if (!path.isEmpty()) {
                        tw.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{path}));
                    }
                }
            }
            tw.setRecursive(true);
            CheckoutData data = new CheckoutData();
            while (tw.next()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                AbstractTreeIterator leftIter = tw.getTree(leftIndex, AbstractTreeIterator.class);
                AbstractTreeIterator rightIter = tw.getTree(rightIndex, AbstractTreeIterator.class);
                if (leftIter instanceof WorkingTreeIterator && rightIter == null && tw.getTree(dirCacheIndex, DirCacheIterator.class) == null && ((WorkingTreeIterator)leftIter).isEntryIgnored()) continue;
                data.clear();
                String gitPath = tw.getPathString();
                Supplier<ITypedElement> leftItem = leftIter instanceof WorkingTreeIterator ? () -> {
                    Path repositoryPath = new Path(repo.getWorkTree().getAbsolutePath());
                    IPath location = repositoryPath.append(gitPath);
                    assert (location != null);
                    IFile file = ResourceUtil.getFileForLocation((IPath)location, (boolean)false);
                    Object item = file != null ? new LocalResourceTypedElement((IResource)file) : new LocalNonWorkspaceTypedElement(repo, location);
                    item.setSharedDocumentListener((EditableSharedDocumentAdapter.ISharedDocumentAdapterListener)new AbstractGitCompareEditorInput.LocalResourceSaver((LocalResourceTypedElement)item));
                    return item;
                } : () -> {
                    data.fill(repo, tw, gitPath);
                    GitFileRevision revision = GitFileRevision.inCommit((Repository)repo, (RevCommit)leftCommit, (String)gitPath, (ObjectId)leftIter.getEntryObjectId(), (DirCacheCheckout.CheckoutMetadata)data.getMetadata());
                    return new FileRevisionTypedElement((IFileRevision)revision, data.getEncoding());
                };
                Supplier<ITypedElement> rightItem = () -> {
                    assert (rightIter != null);
                    data.fill(repo, tw, gitPath);
                    GitFileRevision revision = GitFileRevision.inCommit((Repository)repo, (RevCommit)rightCommit, (String)gitPath, (ObjectId)rightIter.getEntryObjectId(), (DirCacheCheckout.CheckoutMetadata)data.getMetadata());
                    return new FileRevisionTypedElement((IFileRevision)revision, data.getEncoding());
                };
                MergeDiffNode node = this.twoWayDiff(leftIter, rightIter, leftItem, rightItem);
                if (node == null) continue;
                this.getFileParent((IDiffContainer)result, gitPath).add((IDiffElement)node);
            }
            Object object = result.hasChildren() ? result : null;
            return object;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private MergeDiffNode twoWayDiff(AbstractTreeIterator leftIter, AbstractTreeIterator rightIter, Supplier<ITypedElement> leftItem, Supplier<ITypedElement> rightItem) {
        int kind;
        ITypedElement left = null;
        ITypedElement right = null;
        if (leftIter == null) {
            if (rightIter == null) {
                return null;
            }
            kind = 6;
            right = rightItem.get();
        } else if (rightIter == null) {
            kind = 5;
            left = leftItem.get();
        } else {
            if (leftIter.getEntryObjectId().equals((AnyObjectId)rightIter.getEntryObjectId())) {
                return null;
            }
            kind = 3;
            left = leftItem.get();
            right = rightItem.get();
        }
        return new MergeDiffNode(kind, null, left, right);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + Objects.hash(this.leftVersion, this.rightVersion);
        Repository repo = this.getRepository();
        if (repo != null) {
            result = result * 31 + repo.getDirectory().hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GitCompareEditorInput other = (GitCompareEditorInput)((Object)obj);
        if (!Objects.equals(this.rightVersion, other.rightVersion) || !Objects.equals(this.leftVersion, other.leftVersion)) {
            return false;
        }
        Repository repo = this.getRepository();
        File myDir = repo == null ? null : repo.getDirectory();
        repo = other.getRepository();
        File otherDir = repo == null ? null : repo.getDirectory();
        return Objects.equals(myDir, otherDir);
    }

    private static class CheckoutData {
        private boolean filled;
        private String encoding;
        private DirCacheCheckout.CheckoutMetadata metadata;

        private CheckoutData() {
        }

        void fill(Repository repository, TreeWalk walk, String gitPath) {
            if (!this.filled) {
                this.filled = true;
                this.encoding = CompareCoreUtils.getResourceEncoding((Repository)repository, (String)gitPath);
                try {
                    this.metadata = new DirCacheCheckout.CheckoutMetadata(walk.getEolStreamType(TreeWalk.OperationType.CHECKOUT_OP), walk.getFilterCommand("smudge"));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }

        String getEncoding() {
            return this.encoding;
        }

        DirCacheCheckout.CheckoutMetadata getMetadata() {
            return this.metadata;
        }

        void clear() {
            this.filled = false;
            this.encoding = null;
            this.metadata = null;
        }
    }
}

