/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.util;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class Throttler {
    private final Runnable timerExec;
    private final Display display;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private volatile long lastRunNanos;

    public Throttler(Display display, Duration minWaitTime, Runnable runnable) {
        this.display = display;
        if (minWaitTime.isNegative()) {
            throw new IllegalArgumentException("Minimum wait time must be positive");
        }
        if (minWaitTime.toMillis() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Minimum wait time in millis must be smaller than 2147483647");
        }
        int minWaitBetweenRunMillis = (int)minWaitTime.toMillis();
        Runnable runner = () -> {
            this.scheduled.set(false);
            runnable.run();
            this.lastRunNanos = System.nanoTime();
        };
        this.timerExec = () -> {
            long elapsedNanos = System.nanoTime() - this.lastRunNanos;
            long elapsedMillis = elapsedNanos / 1000000L;
            if (elapsedMillis > (long)minWaitBetweenRunMillis) {
                runner.run();
            } else if (!display.isDisposed()) {
                long milisDifference = (long)minWaitBetweenRunMillis - elapsedMillis;
                int milisToWait = Math.max((int)milisDifference, minWaitBetweenRunMillis);
                display.timerExec(milisToWait, runner);
            } else {
                this.scheduled.set(false);
            }
        };
    }

    public void throttledExec() {
        if (this.display.isDisposed()) {
            return;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            if (Thread.currentThread() == this.display.getThread()) {
                this.timerExec.run();
            } else {
                boolean exception = true;
                try {
                    this.display.asyncExec(this.timerExec);
                    exception = false;
                }
                finally {
                    if (exception) {
                        this.scheduled.set(false);
                    }
                }
            }
        }
    }
}

