import { Document, Node } from 'yaml';
import { JSONSchema, JSONSchemaRef } from '../jsonSchema';
import { ValidationResult } from './jsonParser07';
export declare const YAML_SOURCE = "YAML";
/**
 * Error codes used by diagnostics
 */
export declare enum ErrorCode {
    Undefined = 0,
    EnumValueMismatch = 1,
    Deprecated = 2,
    UnexpectedEndOfComment = 257,
    UnexpectedEndOfString = 258,
    UnexpectedEndOfNumber = 259,
    InvalidUnicode = 260,
    InvalidEscapeCharacter = 261,
    InvalidCharacter = 262,
    PropertyExpected = 513,
    CommaExpected = 514,
    ColonExpected = 515,
    ValueExpected = 516,
    CommaOrCloseBacketExpected = 517,
    CommaOrCloseBraceExpected = 518,
    TrailingComma = 519,
    DuplicateKey = 520,
    CommentNotPermitted = 521,
    SchemaResolveError = 768
}
export interface ApplicableSchema {
    node: Node;
    inverted?: boolean;
    schema: JSONSchema;
}
export interface SchemaCollector {
    schemas: ApplicableSchema[];
    add(schema: ApplicableSchema): void;
    merge(other: SchemaCollector): void;
    include(node: Node): boolean;
    newSub(): SchemaCollector;
}
export declare class SchemaCollectorImpl implements SchemaCollector {
    private focusOffset;
    private exclude;
    schemas: ApplicableSchema[];
    constructor(focusOffset?: number, exclude?: Node);
    add(schema: ApplicableSchema): void;
    merge(other: SchemaCollector): void;
    include(node: Node): boolean;
    newSub(): SchemaCollector;
}
export declare function contains(node: Node, offset: number, includeRightBound?: boolean): boolean;
export interface Options {
    isKubernetes: boolean;
    disableAdditionalProperties: boolean;
}
export declare function validate(node: Node, document: Document, schema: JSONSchema, originalSchema: JSONSchema, validationResult: ValidationResult, matchingSchemas: SchemaCollector, options: Options): any;
export declare function asSchema(schema: JSONSchemaRef): JSONSchema;
