/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.markup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.Writer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.DefaultIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguageConfiguration;

public abstract class MarkupLanguage
implements Cloneable {
    private static final DefaultIdGenerationStrategy DEFAULT_ID_GENERATION_STRATEGY = new DefaultIdGenerationStrategy();
    private String name;
    private String extendsLanguage;
    private Set<String> fileExtensions;

    public MarkupLanguage clone() {
        MarkupLanguage markupLanguage;
        try {
            markupLanguage = (MarkupLanguage)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        markupLanguage.setName(this.name);
        markupLanguage.setExtendsLanguage(this.extendsLanguage);
        return markupLanguage;
    }

    public IdGenerationStrategy getIdGenerationStrategy() {
        return DEFAULT_ID_GENERATION_STRATEGY;
    }

    public void configure(MarkupLanguageConfiguration configuration) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getFileExtensions() {
        if (this.fileExtensions == null) {
            return Collections.singleton(this.getName());
        }
        return this.fileExtensions;
    }

    public void setFileExtensions(Set<String> fileExtensions) {
        Objects.requireNonNull(fileExtensions, "Must specify file extensions");
        Preconditions.checkArgument((!fileExtensions.isEmpty() ? 1 : 0) != 0, (Object)"File extensions must not be empty");
        this.fileExtensions = ImmutableSet.copyOf(fileExtensions);
    }

    public String getExtendsLanguage() {
        return this.extendsLanguage;
    }

    public void setExtendsLanguage(String extendsLanguage) {
        this.extendsLanguage = extendsLanguage;
    }

    public abstract void processContent(MarkupParser var1, String var2, boolean var3);

    public DocumentBuilder createDocumentBuilder(Writer out) {
        return this.createDocumentBuilder(out, false);
    }

    public DocumentBuilder createDocumentBuilder(Writer out, boolean formatting) {
        throw new UnsupportedOperationException();
    }
}

