/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.adopter.preference;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wtp.releng.tools.component.ui.Message;

public class ContainerSelectionDialog
extends Dialog {
    private boolean multiSel;
    private Tree tree;
    private TreeViewer treeViewer;
    private IContainer[] selections;
    private List excludes;

    public ContainerSelectionDialog(Shell parent, boolean multiSel, List excludes) {
        super(parent);
        this.setShellStyle(67696);
        this.multiSel = multiSel;
        this.excludes = excludes;
    }

    public IContainer[] getSelections() {
        return this.selections;
    }

    protected void cancelPressed() {
        this.selections = null;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selections = new IContainer[structuredSelection.size()];
            int i = 0;
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                this.selections[i++] = (IContainer)it.next();
            }
        }
        this.setReturnCode(0);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Message.getMessage("TITLE_CONTAINER_SELECTION_DIALOG"));
    }

    protected Control createDialogArea(Composite superparent) {
        Composite parent = new Composite(superparent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        parent.setLayoutData((Object)gd);
        this.tree = this.multiSel ? new Tree(parent, 2818) : new Tree(parent, 2820);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object object) {
                return object instanceof IContainer && (ContainerSelectionDialog.this.excludes == null || !ContainerSelectionDialog.this.excludes.contains(((IContainer)object).getName()));
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        Dialog.applyDialogFont((Control)superparent);
        return parent;
    }
}

