/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wtp.releng.tools.versionchecker.VersionLister;

public class BuildTests
extends TestCase {
    private static final String LIST_TO_REFERENCE_FILE = "-listToReferenceFile";
    private static final String TEST_TO_REFERENCE = "-testToReference";
    private static final String COUNT_QUALIFIER_INCREASE_ONLY_AS_ERROR = "-countQualifierIncreaseOnlyAsError";
    private static final String[] REQUIRED_FEATURE_FILES = new String[]{"epl-v10.html", "feature.properties", "feature.xml", "license.html"};
    private static final String REQUIRED_FEATURE_SUFFIX = ".jpg";
    private static final String[] REQUIRED_PLUGIN_FILES = new String[]{"about.html", "plugin.properties", "plugin.xml"};
    private static final String REQUIRED_PLUGIN_SUFFIX = ".jar";
    private static final String[] REQUIRED_FEATURE_PLUGIN_FILES = new String[]{"about.html", "about.ini", "about.mappings", "about.properties", "plugin.properties", "plugin.xml"};
    private static final String REQUIRED_FEATURE_PLUGIN_SUFFIX = ".gif";
    private static final String[] REQUIRED_FRAGMENT_FILES = new String[]{"fragment.xml"};
    private static final String REQUIRED_FRAGMENT_SUFFIX = "";
    private static final String[] REQUIRED_SWT_FRAGMENT_FILES = new String[]{"fragment.properties"};
    private static final String REQUIRED_SWT_FRAGMENT_SUFFIX = "";
    private static final String[] REQUIRED_SOURCE_FILES = new String[]{"about.html"};
    private static final String REQUIRED_SOURCE_SUFFIX = ".zip";
    private static final String[] REQUIRED_BUNDLE_FILES = new String[]{"about.html"};
    private static final String REQUIRED_BUNDLE_MANIFEST = "MANIFEST.MF";
    private static final String REQUIRED_BUNDLE_SUFFIX = ".jar";
    private static final String[] SUFFIX_EXEMPT_LIST = new String[]{"org.eclipse.swt", "org.apache.ant"};
    private static final int EXPECTED_NUMBER_OF_TOTAL_FEATURES = 155;
    private static final int EXPECTED_NUMBER_OF_TOTAL_PLUGINS = 581;
    private static final int EXPECTED_NUMBER_OF_WTP_FEATURES = 1;
    private static final int EXPECTED_NUMBER_OF_WTP_PLUGINS = 5;
    private static final int EXPECTED_NUMBER_OF_WST_FEATURES = 43;
    private static final int EXPECTED_NUMBER_OF_WST_PLUGINS = 140;
    private static final int EXPECTED_NUMBER_OF_JST_FEATURES = 35;
    private static final int EXPECTED_NUMBER_OF_JST_PLUGINS = 127;
    private static final int EXPECTED_NUMBER_OF_JPT_FEATURES = 6;
    private static final int EXPECTED_NUMBER_OF_JPT_PLUGINS = 12;
    FilenameFilter wtpFilenameFilter = new WTPFileNameFilter();
    FilenameFilter wstFilenameFilter = new WSTFileNameFilter();
    FilenameFilter jstFilenameFilter = new JSTFileNameFilter();
    FilenameFilter jptFilenameFilter = new JPTFileNameFilter();

    public BuildTests(String arg0) {
        super(arg0);
    }

    public void _testFeatureFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles();
        int i = 0;
        while (i < features.length) {
            File aFeature = features[i];
            if (!this.testDirectory(aFeature, REQUIRED_FEATURE_FILES, REQUIRED_FEATURE_SUFFIX)) {
                result.add(aFeature.getPath());
            }
            ++i;
        }
        String aString = "";
        if (result.size() > 0) {
            for (String element : result) {
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        BuildTests.assertTrue((String)("Feature directory missing required files: " + aString), (result.size() == 0 ? 1 : 0) != 0);
    }

    public void __testNumberOfTOTALFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles();
        int nFeatures = features.length;
        if (nFeatures != 155) {
            System.out.println("there were more or less TOTAL features than expected: Found: " + nFeatures + "   Expected: " + 155);
        }
    }

    public void __testNumberOfWTPFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.wtpFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less WTP features than expected: ", (int)1, (int)nFeatures);
    }

    public void __testNumberOfWSTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.wstFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less WST features than expected: ", (int)43, (int)nFeatures);
    }

    public void __testNumberOfJSTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.jstFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less JST features than expected: ", (int)35, (int)nFeatures);
    }

    public void __testNumberOfJPTFeatures() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File featureDir = new File(installDir, "features");
        File[] features = featureDir.listFiles(this.jptFilenameFilter);
        int nFeatures = features.length;
        BuildTests.assertEquals((String)"there were more or less JPT features than expected: ", (int)6, (int)nFeatures);
    }

    public void _testPluginFiles() {
        ArrayList<String> result = new ArrayList<String>();
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles();
        System.out.println("nPlugins: " + plugins.length);
        int i = 0;
        while (i < plugins.length) {
            File aPlugin = plugins[i];
            if (aPlugin.getName().indexOf("test") == -1 && !this.testPluginFile(aPlugin)) {
                result.add(aPlugin.getPath());
            }
            ++i;
        }
        String aString = "";
        if (result.size() > 0) {
            for (String element : result) {
                aString = String.valueOf(aString) + element + "; ";
            }
        }
        BuildTests.assertTrue((String)("Plugin directory missing required files: " + aString), (result.size() == 0 ? 1 : 0) != 0);
    }

    public void __testNumberOfTOTALPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles();
        int nPlugins = plugins.length;
        if (nPlugins != 581) {
            System.out.println("there were more or less TOTAL plugins than expected: Found: " + nPlugins + "   Expected: " + 581);
        }
    }

    public void __testNumberOfWTPPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.wtpFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less WTP plugins than expected: ", (int)5, (int)nPlugins);
    }

    public void __testNumberOfWSTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.wstFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less WST plugins than expected: ", (int)140, (int)nPlugins);
    }

    public void __testNumberOfJSTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.jstFilenameFilter);
        int nPlugins = plugins.length;
        BuildTests.assertEquals((String)"there were more or less JST plugins than expected: ", (int)127, (int)nPlugins);
    }

    public void __testNumberOfJPTPlugins() {
        String installDir = Platform.getInstallLocation().getURL().getPath();
        File pluginDir = new File(installDir, "plugins");
        File[] plugins = pluginDir.listFiles(this.jptFilenameFilter);
        int nPlugins = plugins.length;
        boolean matchedExpectations = nPlugins == 12 || nPlugins == 11;
        BuildTests.assertTrue((String)("there were more or less JPT plugins than expected (+ or - one): " + Integer.toString(12) + " vs " + Integer.toString(nPlugins)), (boolean)matchedExpectations);
    }

    private boolean testPluginFile(File aPlugin) {
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, REQUIRED_SOURCE_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FEATURE_PLUGIN_FILES, REQUIRED_FEATURE_PLUGIN_SUFFIX)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, ".jar")) {
            return true;
        }
        if (this.testSourcePlugin(aPlugin)) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_FRAGMENT_FILES, "") || this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, "")) {
            return true;
        }
        if (this.testDirectory(aPlugin, REQUIRED_SWT_FRAGMENT_FILES, "")) {
            return true;
        }
        return this.testBundleDirectory(aPlugin, REQUIRED_BUNDLE_FILES, REQUIRED_BUNDLE_MANIFEST, ".jar");
    }

    private boolean testPluginJar(File aDirectory, String[] requiredFiles) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ZipFile jarredPlugin = new ZipFile(aDirectory);
            Enumeration<? extends ZipEntry> _enum = jarredPlugin.entries();
            while (_enum.hasMoreElements()) {
                list.add(((Object)_enum.nextElement()).toString());
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list.containsAll(Arrays.asList(requiredFiles));
    }

    private boolean testDirectory(File aDirectory, String[] requiredFiles, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(Arrays.asList(requiredFiles))) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        return true;
    }

    private boolean testBundleDirectory(File aDirectory, String[] requiredFiles, String manifestFile, String requiredSuffix) {
        if (aDirectory.getName().endsWith(".jar")) {
            return this.testPluginJar(aDirectory, requiredFiles);
        }
        if (!Arrays.asList(aDirectory.list()).containsAll(Arrays.asList(requiredFiles))) {
            return false;
        }
        int index = aDirectory.getName().indexOf(95);
        if (index == -1) {
            index = aDirectory.getName().length();
        }
        String plainName = aDirectory.getName().substring(0, index);
        File metaDir = new File(aDirectory, "META-INF");
        String[] metaFiles = metaDir.list();
        if (metaFiles == null) {
            return false;
        }
        int i = 0;
        while (i < metaFiles.length) {
            String filename = metaFiles[i];
            if (filename == manifestFile) {
                return true;
            }
            ++i;
        }
        if (!metaDir.exists()) {
            return false;
        }
        if (requiredSuffix.equals("") || Arrays.asList(SUFFIX_EXEMPT_LIST).contains(plainName)) {
            return true;
        }
        return aDirectory.listFiles(new FileSuffixFilter(requiredSuffix)).length != 0;
    }

    private boolean testSourcePlugin(File aPlugin) {
        if (!this.testDirectory(aPlugin, REQUIRED_PLUGIN_FILES, "")) {
            return false;
        }
        File sourceDir = new File(aPlugin, "src");
        File[] sourceDirs = sourceDir.listFiles();
        if (sourceDirs == null) {
            return false;
        }
        int i = 0;
        while (i < sourceDirs.length) {
            File aSourceDir = sourceDirs[i];
            if (!this.testDirectory(aSourceDir, REQUIRED_SOURCE_FILES, REQUIRED_SOURCE_SUFFIX)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void testVersionCompare() throws Exception {
        VersionLister versionLister = new VersionLister();
        String[] args = this.getArgs();
        Object result = versionLister.run((Object)args);
        boolean testok = IApplication.EXIT_OK.equals(result);
        BuildTests.assertTrue((String)"There is an error in versioning. See full listing for details.", (boolean)testok);
    }

    private String[] getArgs() {
        String qualifierArg = COUNT_QUALIFIER_INCREASE_ONLY_AS_ERROR;
        String testToReferenceArg = TEST_TO_REFERENCE;
        String referenceIDArg = "";
        String referenceURLArg = "";
        String listToReferenceFileArg = LIST_TO_REFERENCE_FILE;
        String propertyFileName = System.getProperty("relengTestsPropertiesFile", "relengTests.properties");
        System.out.println("relengTestsPropertiesFile: " + propertyFileName);
        Properties testProperties = new Properties();
        File propFile = new File(propertyFileName);
        String fullPath = propFile.getAbsolutePath();
        System.out.println("fullPath: " + fullPath);
        if (propFile.exists()) {
            try {
                FileInputStream propertyStream = new FileInputStream(propFile);
                testProperties.load(propertyStream);
                qualifierArg = testProperties.getProperty("qualifierArgValue", "");
                testToReferenceArg = testProperties.getProperty("testToReferenceArgValue", "");
                referenceIDArg = testProperties.getProperty("referenceIDArgValue", "");
                referenceURLArg = testProperties.getProperty("referenceURLArgValue", "");
                listToReferenceFileArg = testProperties.getProperty("listToReferenceFileArgValue", "");
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        } else {
            System.out.println("relengTestsPropertiesFile does not exist");
        }
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.validValue(qualifierArg)) {
            argsList.add(qualifierArg);
        }
        if (this.validValue(testToReferenceArg)) {
            argsList.add(testToReferenceArg);
        }
        if (this.validValue(referenceIDArg)) {
            argsList.add(referenceIDArg);
        }
        if (this.validValue(referenceURLArg)) {
            argsList.add(referenceURLArg);
        }
        if (this.validValue(listToReferenceFileArg)) {
            argsList.add(listToReferenceFileArg);
        }
        String[] args = argsList.toArray(new String[0]);
        return args;
    }

    private boolean validValue(String arg) {
        boolean result = false;
        if (arg != null && arg.length() > 0) {
            result = true;
        }
        return result;
    }

    public void testHTTPSetup() throws Exception {
        try {
            URL url = new URL("http://one.nonesensehostjusttotest.org");
            url.openConnection();
        }
        catch (IOException iOException) {}
    }

    public void testMemory() throws Exception {
        long maxMem = Runtime.getRuntime().maxMemory();
        System.out.printf("%1$20s \t%2$7.2f MB%n", "Max Memory: ", Float.valueOf((float)maxMem / 1000000.0f));
        long totalMem = Runtime.getRuntime().totalMemory();
        System.out.printf("%1$20s \t%2$7.2f MB%n", "Total Memory: ", Float.valueOf((float)totalMem / 1000000.0f));
        long freeMem = Runtime.getRuntime().freeMemory();
        System.out.printf("%1$20s \t%2$7.2f MB%n", "Free Memory: ", Float.valueOf((float)freeMem / 1000000.0f));
    }

    public void testProperties() throws Exception {
        this.dumpAllProperties();
    }

    public void testEnv() throws Exception {
        this.dumpAllEnvVariables();
    }

    void dumpAllEnvVariables() {
        System.out.println();
        System.out.println(" = = = All Environment Variables = = = ");
        System.out.println();
        System.out.println("Environment Variables");
        Map<String, String> envMap = System.getenv();
        for (String key : envMap.keySet()) {
            System.out.print(key);
            int i = 0;
            while (i < 30 - key.length()) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("->" + envMap.get(key));
        }
        System.out.println();
        System.out.println(" = = = All Environment Variables = = = ");
        System.out.println();
    }

    void dumpAllProperties() {
        System.out.println();
        System.out.println(" = = = Dump All Properties = = = ");
        System.out.println();
        Enumeration<Object> enumeration = System.getProperties().keys();
        String key = null;
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            System.out.print(key);
            int i = 0;
            while (i < 30 - key.length()) {
                System.out.print(" ");
                ++i;
            }
            System.out.println("->" + System.getProperty(key));
        }
        System.out.println();
        System.out.println("= = = Dump All Properties = = = ");
        System.out.println();
    }

    public void testDisplay() throws Exception {
        Device.DEBUG = true;
        Display display = new Display();
        Shell shell = new Shell(display);
        System.out.println();
        System.out.println(">>>Attempt creating SWT.MOZILLA-style Browser");
        try {
            new Browser((Composite)shell, 32768);
            System.out.println(">>>succeeded creating SWT.MOZILLA-style Browser");
        }
        catch (Error error) {
            System.out.println(">>>Failed creating SWT.MOZILLA-style Browser");
            System.out.println();
            System.out.println(">>>Attempt creating SWT.NONE-style Browser");
            try {
                new Browser((Composite)shell, 0);
                System.out.println(">>>succeeded creating SWT.NONE-style Browser");
            }
            catch (Error e2) {
                System.out.println(">>>failed creating SWT.NONE-style Browser");
                System.out.println();
                System.out.println(">>>Both attempts methods failed, ending with the following error:");
                e2.printStackTrace();
            }
        }
        display.dispose();
        System.out.println();
    }

    public class FileSuffixFilter
    implements FilenameFilter {
        private String suffix;

        public FileSuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File dir, String name) {
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                return false;
            }
            return name.substring(lastDot).equals(this.suffix);
        }
    }

    public class JPTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.jpt";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class JSTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.jst";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class WSTFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.wst";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }

    public class WTPFileNameFilter
    implements FilenameFilter {
        String namespaceOfInterest = "org.eclipse.wtp";

        public boolean accept(File dir, String name) {
            return dir.getName().startsWith(this.namespaceOfInterest) || name.startsWith(this.namespaceOfInterest);
        }
    }
}

