/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.results.AbstractResults;
import org.eclipse.test.internal.performance.results.ConfigResults;
import org.eclipse.test.internal.performance.results.DB_Results;
import org.eclipse.test.internal.performance.results.PerformanceResults;

public class ScenarioResults
extends AbstractResults {
    String fileName;
    String label;
    String shortName;

    public ScenarioResults(int id, String name, String shortName) {
        super(null, id);
        this.name = name;
        this.label = shortName;
    }

    public String getBaselineBuildName() {
        int size = this.size();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            if (configResults.isValid()) {
                return configResults.getBaselineBuildName();
            }
            ++i;
        }
        return buffer.toString();
    }

    public ConfigResults getConfigResults(String config) {
        return (ConfigResults)this.getResults(config);
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.name.replace('#', '.').replace(':', '_').replace('\\', '_');
        }
        return this.fileName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getShortName() {
        if (this.shortName == null) {
            boolean hasClassName;
            int testSeparator = this.name.indexOf(35);
            boolean bl = hasClassName = testSeparator >= 0;
            if (!hasClassName && (testSeparator = this.name.lastIndexOf(46)) <= 0) {
                this.shortName = this.name;
                return this.shortName;
            }
            int classSeparator = this.name.substring(0, testSeparator).lastIndexOf(46);
            if (classSeparator < 0) {
                this.shortName = this.name;
                return this.shortName;
            }
            int length = this.name.length();
            String testName = this.name.substring(classSeparator + 1, length);
            if (!hasClassName && testName.startsWith("test.")) {
                testName = testName.substring(5);
            }
            StringTokenizer tokenizer = new StringTokenizer(testName, " :,", true);
            StringBuffer buffer = new StringBuffer(tokenizer.nextToken());
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                char fc = token.charAt(0);
                while (fc == ' ' || fc == ',' || fc == ':') {
                    buffer.append(token);
                    token = tokenizer.nextToken();
                    fc = token.charAt(0);
                }
                int last = token.lastIndexOf(46);
                if (last >= 3) {
                    int first = token.indexOf(46);
                    if (first == last) {
                        buffer.append(token);
                        continue;
                    }
                    buffer.append(token.substring(last + 1));
                    continue;
                }
                buffer.append(token);
            }
            this.shortName = buffer.toString();
        }
        return this.shortName;
    }

    public boolean hasSummary() {
        int size = this.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            if (configResults.getCurrentBuildResults().hasSummary()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isValid(String config) {
        return this.getResults(config) != null;
    }

    void read() {
        this.print("+ scenario '" + this.getShortName() + "': ");
        long start = System.currentTimeMillis();
        String configPattern = this.getPerformance().getConfigurationsPattern();
        DB_Results.queryScenarioValues(this, configPattern);
        this.print(" values for " + this.size() + " configs (" + (System.currentTimeMillis() - start) + "ms), ");
        start = System.currentTimeMillis();
        int size = this.size();
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            configResults.update();
            ++i;
        }
        this.println("failures and summaries (" + (System.currentTimeMillis() - start) + "ms).");
    }

    boolean readData(DataInputStream stream, String lastBuildName) throws IOException {
        boolean dirty = false;
        this.print("+ scenario '" + this.getShortName() + "': ");
        long start = System.currentTimeMillis();
        int size = stream.readInt();
        int i = 0;
        while (i < size) {
            int config_id = stream.readInt();
            ConfigResults configResults = (ConfigResults)this.getResults(config_id);
            if (configResults == null) {
                configResults = new ConfigResults((AbstractResults)this, config_id);
                this.addChild(configResults, true);
            }
            configResults.readData(stream);
            ++i;
        }
        this.print(" local data (" + (System.currentTimeMillis() - start) + "ms), ");
        PerformanceResults performanceResults = this.getPerformance();
        start = System.currentTimeMillis();
        String configPattern = performanceResults.getConfigurationsPattern();
        String lastBuildDate = ScenarioResults.getBuildDate(lastBuildName, performanceResults.getBaselinePrefix());
        if (performanceResults.getBuildDate().compareTo(lastBuildDate) > 0) {
            long lastBuildTime = 0L;
            try {
                lastBuildTime = DATE_FORMAT.parse(lastBuildDate).getTime();
            }
            catch (ParseException parseException) {}
            DB_Results.queryScenarioValues(this, configPattern, lastBuildName, lastBuildTime);
            this.print("new data from DB (" + (System.currentTimeMillis() - start) + "ms), ");
            dirty = true;
        }
        start = System.currentTimeMillis();
        size = this.size();
        int i2 = 0;
        while (i2 < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i2);
            configResults.update();
            ++i2;
        }
        this.println("update info (" + (System.currentTimeMillis() - start) + "ms).");
        return dirty;
    }

    void setValue(int build_id, int dim_id, int config_id, int step, long value) {
        ConfigResults configResults = (ConfigResults)this.getResults(config_id);
        if (configResults == null) {
            configResults = new ConfigResults((AbstractResults)this, config_id);
            this.addChild(configResults, true);
        }
        configResults.setValue(build_id, dim_id, step, value);
    }

    void write(DataOutputStream stream) throws IOException {
        int size = this.size();
        stream.writeInt(this.id);
        stream.writeInt(size);
        int i = 0;
        while (i < size) {
            ConfigResults configResults = (ConfigResults)this.children.get(i);
            configResults.write(stream);
            ++i;
        }
    }
}

