/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.Map;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitorLinux;
import org.eclipse.test.internal.performance.PerformanceMonitorMac;
import org.eclipse.test.internal.performance.PerformanceMonitorWindows;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;

class PerformanceMonitor {
    private static PerformanceMonitor fgPerformanceMonitor;

    PerformanceMonitor() {
    }

    public static PerformanceMonitor getPerformanceMonitor() {
        if (fgPerformanceMonitor == null) {
            String os = System.getProperty("os.name");
            fgPerformanceMonitor = os.startsWith("Windows") ? new PerformanceMonitorWindows() : (os.startsWith("Mac OS X") ? new PerformanceMonitorMac() : new PerformanceMonitorLinux());
        }
        return fgPerformanceMonitor;
    }

    protected void collectOperatingSystemCounters(Map scalars) {
        if (PerformanceTestPlugin.isOldDB()) {
            this.addScalar(scalars, InternalDimensions.SYSTEM_TIME, System.currentTimeMillis());
        } else {
            Runtime runtime = Runtime.getRuntime();
            this.addScalar(scalars, InternalDimensions.USED_JAVA_HEAP, runtime.totalMemory() - runtime.freeMemory());
        }
    }

    protected void collectGlobalPerformanceInfo(Map scalars) {
    }

    void addScalar(Map scalars, Dim dimension, long value) {
        scalars.put(dimension, new Scalar(dimension, value));
    }
}

