/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.adopter.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wtp.releng.tools.component.adopters.BreakageReport;
import org.eclipse.wtp.releng.tools.component.adopters.ClassRef;
import org.eclipse.wtp.releng.tools.component.adopters.FieldRef;
import org.eclipse.wtp.releng.tools.component.adopters.MethodRef;
import org.eclipse.wtp.releng.tools.component.adopters.PluginRef;
import org.eclipse.wtp.releng.tools.component.adopters.References;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.internal.SignatureHelper;
import org.eclipse.wtp.releng.tools.component.ui.Message;
import org.eclipse.wtp.releng.tools.component.ui.internal.adopter.preference.UsageReportsPrefPage;
import org.eclipse.wtp.releng.tools.component.ui.internal.adopter.view.BreakageReportView;

public class Scan4APIRefCompatibility
extends Action
implements IActionDelegate {
    private SearchEngine se = new SearchEngine();

    public void run() {
        List refs = UsageReportsPrefPage.getReferences();
        IContainer output = UsageReportsPrefPage.getOutput();
        if (refs.isEmpty()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Message.getMessage("TITLE_USAGE_REPORTS_NOT_FOUND"), (String)Message.getMessage("MSG_ERROR_PLEASE_ADD_USAGE_REPORTS"));
            return;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IStructuredSelection selections = (IStructuredSelection)window.getSelectionService().getSelection();
            Iterator it = selections.iterator();
            while (it.hasNext()) {
                try {
                    IProject project = (IProject)it.next();
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IPath outputLoc = javaProject.getOutputLocation();
                    IFolder bin = (IFolder)ResourcesPlugin.getWorkspace().getRoot().findMember(outputLoc);
                    final HashMap classAPIs = new HashMap();
                    bin.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.getName().endsWith(".class")) {
                                try {
                                    IClassFileReader reader = Scan4APIRefCompatibility.this.read((IFile)proxy.requestResource());
                                    ClassAPI classAPI = new ClassAPI();
                                    String className = new String(reader.getClassName()).replace('/', '.');
                                    classAPI.setName(className);
                                    classAPI.setAccess(reader.getAccessFlags());
                                    classAPI.setSuperClass(new String(reader.getSuperclassName()).replace('/', '.'));
                                    char[][] interfaces = reader.getInterfaceNames();
                                    int i = 0;
                                    while (i < interfaces.length) {
                                        classAPI.addInterface(new String(interfaces[i]).replace('/', '.'));
                                        ++i;
                                    }
                                    classAPIs.put(className, classAPI);
                                    IMethodInfo[] methods = reader.getMethodInfos();
                                    int i2 = 0;
                                    while (i2 < methods.length) {
                                        MethodAPI methodAPI = new MethodAPI();
                                        methodAPI.setName(new String(methods[i2].getName()));
                                        methodAPI.setDescriptor(new String(methods[i2].getDescriptor()));
                                        classAPI.addMethodAPI(methodAPI);
                                        ++i2;
                                    }
                                    IFieldInfo[] fields = reader.getFieldInfos();
                                    int i3 = 0;
                                    while (i3 < fields.length) {
                                        FieldAPI fieldAPI = new FieldAPI();
                                        fieldAPI.setName(new String(fields[i3].getName()));
                                        classAPI.addFieldAPI(fieldAPI);
                                        ++i3;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            return true;
                        }
                    }, 0);
                    String pluginId = project.getName();
                    BreakageReport breakageReport = new BreakageReport();
                    Iterator it4 = refs.iterator();
                    while (it4.hasNext()) {
                        boolean isCompatible = true;
                        References ref = (References)it4.next();
                        References brokenRefs = new References();
                        brokenRefs.setName(ref.getName());
                        brokenRefs.setContactInfo(ref.getContactInfo());
                        brokenRefs.setRefBuildId(ref.getRefBuildId());
                        PluginRef pluginRef = ref.getPluginRef(pluginId);
                        if (pluginRef != null) {
                            PluginRef brokenPluginRef = new PluginRef();
                            brokenPluginRef.setId(pluginId);
                            brokenRefs.addPluginRef(brokenPluginRef);
                            Iterator it2 = pluginRef.getClassRefs().iterator();
                            while (it2.hasNext()) {
                                ClassAPI classAPI;
                                ClassRef classRef = (ClassRef)it2.next();
                                String className = classRef.getName();
                                if (className.endsWith("[]")) {
                                    className = className.substring(0, className.length() - 2);
                                }
                                if ((classAPI = (ClassAPI)classAPIs.get(className)) == null && className.indexOf(36) < 0) {
                                    brokenPluginRef.addClassRef(classRef);
                                    isCompatible = false;
                                    continue;
                                }
                                if (className.indexOf(36) >= 0) continue;
                                Iterator it3 = classRef.getMethodRefs().iterator();
                                while (it3.hasNext()) {
                                    String methodDescriptor;
                                    MethodRef methodRef = (MethodRef)it3.next();
                                    String methodName = methodRef.getName();
                                    if (this.methodExists(classAPIs, className, methodName, methodDescriptor = methodRef.getDescriptor(), javaProject)) continue;
                                    ClassRef brokenClassRef = brokenPluginRef.getClassRef(className);
                                    if (brokenClassRef == null) {
                                        brokenClassRef = new ClassRef();
                                        brokenClassRef.setName(className);
                                        brokenPluginRef.addClassRef(brokenClassRef);
                                    }
                                    brokenClassRef.addMethodRef(methodRef);
                                    isCompatible = false;
                                }
                                it3 = classRef.getFieldRefs().iterator();
                                while (it3.hasNext()) {
                                    FieldRef fieldRef = (FieldRef)it3.next();
                                    String fieldName = fieldRef.getName();
                                    if (this.fieldExists(classAPIs, className, fieldName, javaProject)) continue;
                                    ClassRef brokenClassRef = brokenPluginRef.getClassRef(className);
                                    if (brokenClassRef == null) {
                                        brokenClassRef = new ClassRef();
                                        brokenClassRef.setName(className);
                                        brokenPluginRef.addClassRef(brokenClassRef);
                                    }
                                    brokenClassRef.addFieldRef(fieldRef);
                                    isCompatible = false;
                                }
                            }
                        }
                        if (isCompatible) continue;
                        breakageReport.addRefs(brokenRefs);
                    }
                    BreakageReportView view = (BreakageReportView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.wtp.releng.tools.component.ui.internal.adopter.view.BreakageReportView");
                    StringBuffer sb = new StringBuffer();
                    sb.append(pluginId);
                    sb.append(".breakage");
                    IFile file = output.getFile((IPath)new Path(sb.toString()));
                    if (breakageReport.getRefs().isEmpty()) {
                        if (file.exists()) {
                            file.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
                        }
                        view.clear();
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Message.getMessage("TITLE_COMPATIBLE_WITH_USAGE_REPORTS"), (String)Message.getMessage("MSG_INFO_COMPATIBLE_WITH_USAGE_REPORTS"));
                        continue;
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(breakageReport.toString().getBytes());
                    if (file.exists()) {
                        file.setContents((InputStream)bais, true, false, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        file.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    view.setFocus();
                    view.refresh();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private IClassFileReader read(IFile file) throws IOException, ClassFormatException, CoreException {
        ClassFileReader classFileReader;
        ByteArrayOutputStream baos;
        block11: {
            InputStream is = null;
            baos = null;
            try {
                byte[] b = new byte[8192];
                baos = new ByteArrayOutputStream(8192);
                is = file.getContents();
                int read = is.read(b);
                while (read != -1) {
                    baos.write(b, 0, read);
                    read = is.read(b);
                }
                is.close();
                baos.close();
                classFileReader = new ClassFileReader(baos.toByteArray(), 47);
                Object var6_7 = null;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos == null) break block13;
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
    }

    private boolean methodExists(Map classAPIs, String className, String methodName, String methodDescriptor, IJavaProject javaProject) {
        if (methodName.indexOf(36) > -1) {
            return true;
        }
        ClassAPI classAPI = (ClassAPI)classAPIs.get(className);
        if (classAPI != null) {
            if (classAPI.getMethodAPI(methodName, methodDescriptor) != null) {
                return true;
            }
            String superClassName = classAPI.getSuperClass();
            boolean exists = this.methodExists(classAPIs, superClassName, methodName, methodDescriptor, javaProject);
            if (exists) {
                return true;
            }
            Iterator it = classAPI.getInterfaces().iterator();
            while (it.hasNext()) {
                String superInterfaceName = (String)it.next();
                exists = this.methodExists(classAPIs, superInterfaceName, methodName, methodDescriptor, javaProject);
                if (!exists) continue;
                return true;
            }
            return false;
        }
        try {
            IType type = this.getType(javaProject, className);
            return this.methodExists(javaProject, type, methodName, this.toParameterTypes(methodDescriptor));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private boolean fieldExists(Map classAPIs, String className, String fieldName, IJavaProject javaProject) {
        ClassAPI classAPI = (ClassAPI)classAPIs.get(className);
        if (classAPI != null) {
            if (classAPI.getFieldAPI(fieldName) != null) {
                return true;
            }
            String superClassName = classAPI.getSuperClass();
            boolean exists = this.fieldExists(classAPIs, superClassName, fieldName, javaProject);
            if (exists) {
                return true;
            }
            Iterator it = classAPI.getInterfaces().iterator();
            while (it.hasNext()) {
                String superInterfaceName = (String)it.next();
                exists = this.fieldExists(classAPIs, superInterfaceName, fieldName, javaProject);
                if (!exists) continue;
                return true;
            }
            return false;
        }
        try {
            IType type = this.getType(javaProject, className);
            return this.fieldExists(javaProject, type, fieldName);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private IType getType(IJavaProject javaProject, String className) throws CoreException {
        innerClassTokens = null;
        if (className.indexOf(36) != -1) {
            innerClassTokens = new StringTokenizer(className, "$");
            className = innerClassTokens.nextToken();
        }
        spattern = SearchPattern.createPattern((String)className, (int)10, (int)0, (int)0);
        sparticipant = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        ijss = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        csr = new ClassSearchRequestor();
        this.se.search(spattern, sparticipant, ijss, (SearchRequestor)csr, (IProgressMonitor)new NullProgressMonitor());
        type = csr.getType();
        if (type == null) {
            return null;
        }
        if (innerClassTokens != null) ** GOTO lbl17
        return type;
lbl-1000:
        // 1 sources

        {
            if ((type = type.getType(innerClassTokens.nextToken())) != null) continue;
            return null;
lbl17:
            // 2 sources

            ** while (innerClassTokens.hasMoreTokens())
        }
lbl18:
        // 1 sources

        return type;
    }

    private String[] toParameterTypes(String desc) {
        String[] paramTypes = Signature.getParameterTypes((String)desc);
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = paramTypes[i].replace('/', '.');
            ++i;
        }
        return paramTypes;
    }

    private boolean methodExists(IJavaProject javaProject, IType type, String name, String[] paramTypes) throws JavaModelException, CoreException {
        if (type != null) {
            IMethod method = type.getMethod(name, paramTypes);
            if (method.exists() || this.sourceMethodExists(method, type)) {
                return true;
            }
            if (type.isClass()) {
                String superClassName = type.getSuperclassName();
                if (superClassName != null) {
                    IType superType = this.getType(javaProject, superClassName);
                    return this.methodExists(javaProject, superType, name, paramTypes);
                }
            } else {
                String[] interfaceNames = type.getSuperInterfaceNames();
                int i = 0;
                while (i < interfaceNames.length) {
                    if (this.methodExists(javaProject, this.getType(javaProject, interfaceNames[i]), name, paramTypes)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean sourceMethodExists(IMethod method, IType type) throws JavaModelException {
        IMethod[] similarMethods = Scan4APIRefCompatibility.findSimilarMethods(method, type);
        int i = 0;
        while (i < similarMethods.length) {
            boolean foundMatch = true;
            String[] similarParameterTypes = similarMethods[i].getParameterTypes();
            int j = 0;
            while (j < similarParameterTypes.length) {
                String methodParamSignature;
                String similarParamSignature = SignatureHelper.getSignatureResolvedName((char[])similarParameterTypes[j].toCharArray(), (IType)type);
                if (!similarParamSignature.equals(methodParamSignature = SignatureHelper.getSignatureResolvedName((char[])method.getParameterTypes()[j].toCharArray(), (IType)type))) {
                    foundMatch = false;
                    break;
                }
                ++j;
            }
            if (foundMatch) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean fieldExists(IJavaProject javaProject, IType type, String name) throws JavaModelException, CoreException {
        if (type != null) {
            IField field = type.getField(name);
            if (field.exists()) {
                return true;
            }
            if (type.isClass()) {
                String superClassName = type.getSuperclassName();
                if (superClassName != null) {
                    IType superType = this.getType(javaProject, superClassName);
                    return this.fieldExists(javaProject, superType, name);
                }
            } else {
                String[] interfaceNames = type.getSuperInterfaceNames();
                int i = 0;
                while (i < interfaceNames.length) {
                    if (this.fieldExists(javaProject, this.getType(javaProject, interfaceNames[i]), name)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static IMethod[] findSimilarMethods(IMethod method, IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        ArrayList<IMethod> similarMethods = new ArrayList<IMethod>();
        boolean isConstructor = method.isConstructor();
        int i = 0;
        while (i < methods.length) {
            IMethod otherMethod = methods[i];
            if (otherMethod.isConstructor() == isConstructor && method.isSimilar(otherMethod)) {
                similarMethods.add(otherMethod);
            }
            ++i;
        }
        return similarMethods.toArray(new IMethod[similarMethods.size()]);
    }

    private class ClassSearchRequestor
    extends SearchRequestor {
        private IType type;

        private ClassSearchRequestor() {
        }

        public IType getType() {
            return this.type;
        }

        public void acceptSearchMatch(SearchMatch match) {
            Object element = match.getElement();
            if (element instanceof IType) {
                this.type = (IType)element;
            }
        }
    }
}

