/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class WsdlToDotnet
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File destFile = null;
    private String language = "CS";
    private boolean server = false;
    private String namespace = null;
    private boolean failOnError = true;
    protected String extraOptions = null;
    private String protocol = null;
    private boolean ideErrors = false;
    private Vector schemas = new Vector();
    private Schema wsdl = new Schema();
    private Compiler compiler = null;
    public static final String ERROR_DEST_FILE_IS_DIR = "destination file is a directory";
    public static final String ERROR_NO_DEST_FILE = "destination file must be specified";

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setUrl(String url) {
        this.wsdl.setUrl(url);
    }

    public void setSrcFile(File srcFile) {
        this.wsdl.setFile(srcFile);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setServer(boolean server) {
        this.server = server;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setExtraOptions(String extraOptions) {
        this.extraOptions = extraOptions;
    }

    public void setIdeErrors(boolean ideErrors) {
        this.ideErrors = ideErrors;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void addSchema(Schema source) {
        this.schemas.add(source);
    }

    public void setMakeURL(boolean b) {
        this.wsdl.setMakeURL(b);
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    protected void validate() throws BuildException {
        if (this.destFile == null) {
            throw new BuildException(ERROR_NO_DEST_FILE);
        }
        if (this.destFile.isDirectory()) {
            throw new BuildException(ERROR_DEST_FILE_IS_DIR);
        }
        this.wsdl.validate();
    }

    public void execute() throws BuildException {
        this.log("This task is deprecated and will be removed in a future version\nof Ant.  It is now part of the .NET Antlib:\nhttp://ant.apache.org/antlibs/dotnet/index.html", 1);
        if (this.compiler == null) {
            this.compiler = Compiler.createDefaultCompiler();
        }
        this.validate();
        NetCommand command = new NetCommand(this, "WSDL", this.compiler.getCommand());
        command.setFailOnError(this.failOnError);
        this.compiler.applyExtraArgs(command);
        command.addArgument("/nologo");
        command.addArgument("/out:" + this.destFile);
        command.addArgument("/language:", this.language);
        if (this.server) {
            command.addArgument("/server");
        }
        command.addArgument("/namespace:", this.namespace);
        if (this.protocol != null) {
            command.addArgument("/protocol:" + this.protocol);
        }
        if (this.ideErrors) {
            command.addArgument("/parsableErrors");
        }
        command.addArgument(this.extraOptions);
        boolean rebuild = true;
        long destLastModified = -1L;
        if (this.destFile.exists()) {
            destLastModified = this.destFile.lastModified();
            rebuild = this.isRebuildNeeded(this.wsdl, destLastModified);
        }
        String path = this.wsdl.evaluate();
        if (!this.compiler.supportsAbsoluteFiles() && this.wsdl.getFile() != null) {
            File f = this.wsdl.getFile();
            command.setDirectory(f.getParentFile());
            path = f.getName();
        }
        command.addArgument(path);
        Iterator it = this.schemas.iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            rebuild |= this.isRebuildNeeded(schema, destLastModified);
            command.addArgument(schema.evaluate());
        }
        if (rebuild) {
            command.runCommand();
        }
    }

    private boolean isRebuildNeeded(Schema schema, long destLastModified) {
        if (destLastModified == -1L) {
            return true;
        }
        return !FILE_UTILS.isUpToDate(schema.getTimestamp(), destLastModified);
    }

    public static class Compiler
    extends EnumeratedAttribute {
        public static final String COMPILER_MS = "microsoft";
        public static final String COMPILER_MONO = "mono";
        public static final String COMPILER_MS_ON_MONO = "microsoft-on-mono";
        String[] compilers = new String[]{"microsoft", "mono", "microsoft-on-mono"};
        public static final String EXE_WSDL = "wsdl";
        public static final String EXE_MONO = "mono";
        String[] compilerExecutables = new String[]{"wsdl", "wsdl", "mono"};
        String[][] extraCompilerArgs = new String[][]{new String[0], new String[0], {"wsdl.exe"}};
        boolean[] absoluteFiles = new boolean[]{true, false, true};

        public String[] getValues() {
            return this.compilers;
        }

        public static Compiler createDefaultCompiler() {
            Compiler c = new Compiler();
            String compilerName = Os.isFamily((String)"windows") ? COMPILER_MS : "mono";
            c.setValue(compilerName);
            return c;
        }

        public String getCommand() {
            return this.compilerExecutables[this.getIndex()];
        }

        public String[] getExtraArgs() {
            return this.extraCompilerArgs[this.getIndex()];
        }

        public boolean supportsAbsoluteFiles() {
            return this.absoluteFiles[this.getIndex()];
        }

        public void applyExtraArgs(NetCommand command) {
            String[] args = this.getExtraArgs();
            for (int i = 0; i < args.length; ++i) {
                command.addArgument(args[i]);
            }
        }
    }

    public static class Schema {
        private File file;
        private String url;
        private boolean makeURL = false;
        public static final String ERROR_NONE_DECLARED = "One of file and url must be set";
        public static final String ERROR_BOTH_DECLARED = "Only one of file or url can be set";
        public static final String ERROR_FILE_NOT_FOUND = "Not found: ";
        public static final String ERROR_FILE_IS_DIR = "File is a directory: ";
        public static final String ERROR_NO_URL_CONVERT = "Could not URL convert ";

        public void validate() {
            if (this.file != null) {
                if (!this.file.exists()) {
                    throw new BuildException(ERROR_FILE_NOT_FOUND + this.file.toString());
                }
                if (this.file.isDirectory()) {
                    throw new BuildException(ERROR_FILE_IS_DIR + this.file.toString());
                }
            }
            if (this.file != null && this.url != null) {
                throw new BuildException(ERROR_BOTH_DECLARED);
            }
            if (this.file == null && this.url == null) {
                throw new BuildException(ERROR_NONE_DECLARED);
            }
        }

        public String evaluate() {
            this.validate();
            if (this.url != null) {
                return this.getUrl();
            }
            if (this.makeURL) {
                try {
                    return this.file.toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    throw new BuildException(ERROR_NO_URL_CONVERT + this.file);
                }
            }
            return this.file.toString();
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public boolean isMakeURL() {
            return this.makeURL;
        }

        public void setMakeURL(boolean makeURL) {
            this.makeURL = makeURL;
        }

        public long getTimestamp() {
            if (this.file != null) {
                return this.file.lastModified();
            }
            return -1L;
        }
    }
}

