/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.IJavaVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.IZipLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PDESourceVisitor
implements ILocationVisitor {
    private IJavaVisitor javaVisitor = null;
    private List srcs = new ArrayList();
    private Collection excludes;

    public void setJavaVisitor(IJavaVisitor javaVisitor) {
        this.javaVisitor = javaVisitor;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public boolean accept(ILocation location) {
        String pluginId;
        String locationName = location.getName();
        String absPath = location.getAbsolutePath();
        if (this.javaVisitor == null && (locationName.endsWith("plugin.xml") || locationName.endsWith("fragment.xml"))) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(location.getInputStream());
                Element root = doc.getDocumentElement();
                NodeList exts = root.getElementsByTagName("extension");
                int i = 0;
                while (i < exts.getLength()) {
                    Element ext = (Element)exts.item(i);
                    if ("org.eclipse.pde.core.source".equals(ext.getAttribute("point"))) {
                        NodeList locs = ext.getElementsByTagName("location");
                        int j = 0;
                        while (j < locs.getLength()) {
                            Element loc = (Element)locs.item(j);
                            String path = loc.getAttribute("path");
                            if (path != null && path.length() > 0) {
                                StringBuffer sb = new StringBuffer();
                                if (locationName.endsWith("plugin.xml")) {
                                    sb.append(absPath.substring(0, absPath.length() - "plugin.xml".length() - 1));
                                } else {
                                    sb.append(absPath.substring(0, absPath.length() - "fragment.xml".length() - 1));
                                }
                                sb.append("/");
                                sb.append(path);
                                this.srcs.add(sb.toString());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {}
        } else if (this.javaVisitor != null && locationName.endsWith("src.zip") && (pluginId = this.getPluginId(absPath)) != null && (this.excludes == null || !this.excludes.contains(pluginId))) {
            ILocationChildrenIterator it = location.childIterator();
            ILocation child = it.next();
            while (child != null) {
                if (child.getName().endsWith(".java")) {
                    this.javaVisitor.visit(pluginId, child);
                }
                child = it.next();
            }
        }
        if (location instanceof IZipLocation) {
            return true;
        }
        return location instanceof IFileLocation && ((IFileLocation)location).getFile().isDirectory();
    }

    private String getPluginId(String name) {
        Iterator it = this.srcs.iterator();
        while (it.hasNext()) {
            String src = (String)it.next();
            if (!name.startsWith(src)) continue;
            int startIndex = src.length() + 1;
            int endIndex = name.indexOf(47, startIndex);
            if (endIndex == -1) {
                endIndex = name.indexOf(92, startIndex);
            }
            if (endIndex == -1) continue;
            String id = name.substring(startIndex, endIndex);
            int versionIndex = id.indexOf(95);
            if (versionIndex != -1) {
                id = id.substring(0, versionIndex);
            }
            return id;
        }
        return null;
    }
}

