/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.ILibrary;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.ui.internal.BundleLibrary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleAdapter
implements IPluginXML {
    private Bundle bundle;
    private List libraries;

    public BundleAdapter(Bundle bundle) {
        this.bundle = bundle;
    }

    public List getLibraries() {
        if (this.libraries == null) {
            this.libraries = new ArrayList(1);
            String classpathHeader = (String)this.bundle.getHeaders().get("Bundle-ClassPath");
            if (classpathHeader != null) {
                try {
                    ManifestElement[] classpaths = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpathHeader);
                    if (classpaths != null) {
                        int i = 0;
                        while (i < classpaths.length) {
                            this.libraries.add(new BundleLibrary(this.bundle, classpaths[i]));
                            ++i;
                        }
                    }
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.libraries;
    }

    public String getName() {
        return this.bundle.getSymbolicName();
    }

    public String getVersion() {
        return (String)this.bundle.getHeaders().get("Bundle-Version");
    }

    public String getUniqueIdentifier() {
        return String.valueOf(this.getName()) + "_" + this.getVersion();
    }

    public void accept(IClazzVisitor visitor) {
        Iterator it = this.getLibraries().iterator();
        while (it.hasNext()) {
            ILibrary lib = (ILibrary)it.next();
            lib.accept(visitor);
            lib.resetTypes();
        }
    }
}

