/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.image;

import com.sun.media.jai.codec.FileSeekableStream;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.optional.image.Draw;
import org.apache.tools.ant.types.optional.image.ImageOperation;
import org.apache.tools.ant.types.optional.image.Rotate;
import org.apache.tools.ant.types.optional.image.Scale;
import org.apache.tools.ant.types.optional.image.TransformOperation;

public class Image
extends MatchingTask {
    protected Vector instructions = new Vector();
    protected boolean overwrite = false;
    protected Vector filesets = new Vector();
    protected File srcDir = null;
    protected File destDir = null;
    protected String str_encoding = "JPEG";
    protected boolean garbage_collect = false;
    private boolean failonerror = true;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setEncoding(String encoding) {
        this.str_encoding = encoding;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setGc(boolean gc) {
        this.garbage_collect = gc;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addImageOperation(ImageOperation instr) {
        this.instructions.add(instr);
    }

    public void addRotate(Rotate instr) {
        this.instructions.add(instr);
    }

    public void addScale(Scale instr) {
        this.instructions.add(instr);
    }

    public void addDraw(Draw instr) {
        this.instructions.add(instr);
    }

    public void add(ImageOperation instr) {
        this.addImageOperation(instr);
    }

    public void processFile(File file) {
        try {
            this.log("Processing File: " + file.getAbsolutePath());
            FileSeekableStream input = new FileSeekableStream(file);
            RenderedOp image = JAI.create((String)"stream", (Object)input);
            for (int i = 0; i < this.instructions.size(); ++i) {
                Object instr = this.instructions.elementAt(i);
                if (instr instanceof TransformOperation) {
                    image = ((TransformOperation)((Object)instr)).executeTransformOperation((PlanarImage)image);
                    continue;
                }
                this.log("Not a TransformOperation: " + instr);
            }
            input.close();
            if (this.str_encoding.toLowerCase().equals("jpg")) {
                this.str_encoding = "JPEG";
            } else if (this.str_encoding.toLowerCase().equals("tif")) {
                this.str_encoding = "TIFF";
            }
            if (this.destDir == null) {
                this.destDir = this.srcDir;
            }
            File newFile = new File(this.destDir, file.getName());
            if (this.overwrite && newFile.exists() && !newFile.equals(file)) {
                newFile.delete();
            }
            FileOutputStream stream = new FileOutputStream(newFile);
            JAI.create((String)"encode", (RenderedImage)image, (Object)stream, (Object)this.str_encoding.toUpperCase(), null);
            stream.flush();
            stream.close();
        }
        catch (IOException err) {
            if (!this.failonerror) {
                this.log("Error processing file:  " + err);
            }
            throw new BuildException((Throwable)err);
        }
        catch (RuntimeException rerr) {
            if (!this.failonerror) {
                this.log("Error processing file:  " + rerr);
            }
            throw new BuildException((Throwable)rerr);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            int i;
            DirectoryScanner ds = null;
            String[] files = null;
            ArrayList<File> filesList = new ArrayList<File>();
            if (this.srcDir != null) {
                ds = super.getDirectoryScanner(this.srcDir);
                files = ds.getIncludedFiles();
                for (i = 0; i < files.length; ++i) {
                    filesList.add(new File(this.srcDir, files[i]));
                }
            }
            for (i = 0; i < this.filesets.size(); ++i) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                ds = fs.getDirectoryScanner(this.getProject());
                files = ds.getIncludedFiles();
                File fromDir = fs.getDir(this.getProject());
                for (int j = 0; j < files.length; ++j) {
                    filesList.add(new File(fromDir, files[j]));
                }
            }
            if (!this.overwrite) {
                ArrayList<File> filesToRemove = new ArrayList<File>();
                Iterator i2 = filesList.iterator();
                while (i2.hasNext()) {
                    File f = (File)i2.next();
                    File newFile = new File(this.destDir, f.getName());
                    if (!newFile.exists()) continue;
                    filesToRemove.add(f);
                }
                filesList.removeAll(filesToRemove);
            }
            Iterator i3 = filesList.iterator();
            while (i3.hasNext()) {
                File file = (File)i3.next();
                this.processFile(file);
                if (!this.garbage_collect) continue;
                System.gc();
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            throw new BuildException(err.getMessage());
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.srcDir == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source--a srcDir or a fileset.");
        }
        if (this.srcDir == null && this.destDir == null) {
            throw new BuildException("Specify the destDir, or the srcDir.");
        }
    }
}

