/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.adopters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.adopters.ComponentTeamScanner;
import org.eclipse.wtp.releng.tools.component.adopters.IOutputConstants;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class ExtensionPointScanner
extends ComponentTeamScanner
implements IPlatformRunnable,
IOutputConstants {
    public static final String ARG_FILTERS = "extpt";
    public static final String ARG_OUTPUT = "output";
    public static final String ARG_INCLUDES = "includes";
    public static final String ARG_EXCLUDES = "excludes";
    private Collection filters;
    private String output;
    private Collection includes;
    private Collection excludes;
    private static final String EXTENSION_POINT_USAGE_FILE = "org/eclipse/wtp/releng/tools/component/xsl/extpt.xsl";
    private static final String HTML_OUTPUT_EXTENSION = "/extpt.html";

    public Collection getFilters() {
        return this.filters;
    }

    public void setFilters(Collection someFilters) {
        this.filters = someFilters;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String anOutput) {
        this.output = anOutput;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection someExcludes) {
        this.excludes = someExcludes;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection someIncludes) {
        this.includes = someIncludes;
    }

    private boolean include(String s) {
        Iterator it;
        if (this.getExcludes() != null && !this.getExcludes().isEmpty()) {
            it = this.getExcludes().iterator();
            while (it.hasNext()) {
                if (!s.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!s.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void execute() {
        IExtensionPoint[] extpts = Platform.getExtensionRegistry().getExtensionPoints();
        int i = 0;
        while (i < extpts.length) {
            String extPtId = extpts[i].getUniqueIdentifier();
            String pluginId = extpts[i].getNamespaceIdentifier();
            if (extPtId != null) {
                Iterator it = this.getFilters().iterator();
                while (it.hasNext()) {
                    if (!extPtId.matches((String)it.next())) continue;
                    int extptRefCount = 0;
                    IExtension[] exts = extpts[i].getExtensions();
                    int j = 0;
                    while (j < exts.length) {
                        if (this.include(exts[j].getNamespaceIdentifier())) {
                            ++extptRefCount;
                        }
                        ++j;
                    }
                    ComponentTeamScanner.ComponentTeam compTeam = this.getComponentTeam(pluginId);
                    compTeam.getExtensionPointReferenceCounts().put(extPtId, String.valueOf(extptRefCount));
                    break;
                }
            }
            ++i;
        }
        this.generateHTMLFile();
    }

    private void generateHTMLFile() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("<root>".getBytes());
            int i = 0;
            while (i < this.getComponentTeams().size()) {
                ComponentTeamScanner.ComponentTeam compTeam = (ComponentTeamScanner.ComponentTeam)this.getComponentTeams().get(i);
                this.writeCompTeamXML(compTeam, baos);
                ++i;
            }
            baos.write("</root>".getBytes());
            baos.close();
            XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource(EXTENSION_POINT_USAGE_FILE).openStream(), new ByteArrayInputStream(baos.toByteArray()), (OutputStream)new FileOutputStream(String.valueOf(this.getOutput()) + HTML_OUTPUT_EXTENSION));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void writeCompTeamXML(ComponentTeamScanner.ComponentTeam compTeam, ByteArrayOutputStream baos) throws IOException {
        baos.write("<team lead=\"".getBytes());
        baos.write(compTeam.getTeamName().getBytes());
        baos.write("\">".getBytes());
        Iterator it = compTeam.getExtensionPointReferenceCounts().keySet().iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            String refCount = (String)compTeam.getExtensionPointReferenceCounts().get(id);
            baos.write("<extpt id=\"".getBytes());
            baos.write(id.getBytes());
            baos.write("\" ref=\"".getBytes());
            baos.write(refCount.getBytes());
            baos.write("\"/>".getBytes());
        }
        baos.write("</team>".getBytes());
    }

    public Object run(Object arguments) {
        String vmExtpt = System.getProperty(ARG_FILTERS);
        String vmOutput = System.getProperty(ARG_OUTPUT);
        String vmIncludes = System.getProperty(ARG_INCLUDES);
        String vmExcludes = System.getProperty(ARG_EXCLUDES);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-extpt");
        args.addAll(this.tokenize(vmExtpt));
        args.add("-output");
        args.add(vmOutput);
        if (vmIncludes != null) {
            args.add("-includes");
            args.addAll(this.tokenize(vmIncludes));
        }
        if (vmExcludes != null) {
            args.add("-excludes");
            args.addAll(this.tokenize(vmExcludes));
        }
        try {
            ExtensionPointScanner.main(args.toArray(new String[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private List tokenize(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection optionsExtpt = (Collection)options.get(ARG_FILTERS);
        Collection optionsOutput = (Collection)options.get(ARG_OUTPUT);
        Collection optionsIncludes = (Collection)options.get(ARG_INCLUDES);
        Collection optionsExcludes = (Collection)options.get(ARG_EXCLUDES);
        if (optionsExtpt == null || optionsOutput == null || optionsExtpt.isEmpty() || optionsOutput.isEmpty()) {
            ExtensionPointScanner.printUsage();
            System.exit(-1);
        }
        ExtensionPointScanner scanner = new ExtensionPointScanner();
        scanner.setFilters(optionsExtpt);
        scanner.setOutput((String)optionsOutput.iterator().next());
        scanner.setIncludes(optionsIncludes);
        scanner.setExcludes(optionsExcludes);
        scanner.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.adopters.ExtensionPointScanner -extpt -output [options]");
        System.out.println("");
        System.out.println("\t-extpt\t\t<extpt>\t\tregular expressions for filtering your extension points");
        System.out.println("\t-output\t\t<output>\t\toutput directory");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated extensions to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated extensions to exclude");
    }
}

