/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.API2ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.violation.ClassViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentAPIViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.FieldViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.MethodViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ParamViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ReturnViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.SuperViolation;
import org.eclipse.wtp.releng.tools.component.api.violation.ThrowViolation;
import org.eclipse.wtp.releng.tools.component.images.ImagesUtil;
import org.eclipse.wtp.releng.tools.component.internal.ComponentEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class NonAPIDependencyScanner
implements ILocationVisitor {
    private Collection src;
    private Collection api;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private Collection refapi;
    private boolean skipAPIGen;
    private API2ComponentAPI api2CompXML;
    private ComponentSummary summary;
    private Map pluginId2CompXML = new HashMap();

    public Collection getApi() {
        return this.api;
    }

    public void setApi(Collection api) {
        this.api = api;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public Collection getRefapi() {
        return this.refapi;
    }

    public void setRefapi(Collection refapi) {
        this.refapi = refapi;
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(Collection src) {
        this.src = src;
    }

    public boolean isSkipAPIGen() {
        return this.skipAPIGen;
    }

    public void setSkipAPIGen(boolean skipAPIGen) {
        this.skipAPIGen = skipAPIGen;
    }

    public void execute() {
        this.cacheCompXML(this.api);
        this.cacheCompXML(this.refapi);
        this.api2CompXML = new API2ComponentAPI();
        this.api2CompXML.setApi(this.api);
        this.api2CompXML.setSrc(this.src);
        this.api2CompXML.setOutputDir(this.outputDir);
        this.api2CompXML.setReadInterface(true);
        this.api2CompXML.setSkipAPIGen(this.skipAPIGen);
        this.api2CompXML.execute();
        this.summary = new ComponentSummary();
        ILocation out = Location.createLocation(new File(this.outputDir));
        out.accept(this);
        try {
            ImagesUtil.copyAll(this.outputDir);
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/component-api-violation.xsl"), new ByteArrayInputStream(this.summary.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "component-api-violation-all.html")), this.outputDir);
        }
        catch (Throwable throwable) {
            try {
                XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/component-api-violation.xsl").openStream(), new ByteArrayInputStream(this.summary.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "component-api-violation-all.html")), this.outputDir);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    private void cacheCompXML(Collection locations) {
        Iterator i = locations.iterator();
        while (i.hasNext()) {
            String locationString = (String)i.next();
            ILocation apiLocation = Location.createLocation(new File(locationString));
            ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
            if (apiLocation == null) {
                System.out.println("ERROR - Can't find location at: " + locationString);
                continue;
            }
            apiLocation.accept(compXMLVisitor);
            Iterator it = compXMLVisitor.getCompXMLs().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                Iterator it2 = compXML.getPlugins().iterator();
                while (it2.hasNext()) {
                    this.pluginId2CompXML.put(((Plugin)it2.next()).getId(), compXML);
                }
            }
        }
    }

    public boolean accept(ILocation location) {
        if (location.getName().equals("api-info.xml")) {
            try {
                ComponentAPI compAPI = new ComponentAPI();
                compAPI.setLocation(location);
                compAPI.load();
                ComponentAPIViolation violation = this.getViolations(compAPI);
                String compName = compAPI.getName();
                StringBuffer sb = new StringBuffer(this.outputDir);
                sb.append(compName);
                sb.append("/component-api-violation.xml");
                File file = new File(sb.toString());
                file.getParentFile().mkdirs();
                FileOutputStream fos = new FileOutputStream(file);
                String content = violation.toString();
                fos.write(content.getBytes());
                fos.close();
                ComponentEntry entry = new ComponentEntry();
                entry.setCompName(compName);
                entry.setRef(sb.toString());
                this.summary.add(entry);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return true;
    }

    private ComponentAPIViolation getViolations(ComponentAPI compAPI) {
        String compName = compAPI.getName();
        ComponentAPIViolation v = new ComponentAPIViolation();
        v.setName(compName);
        Iterator it = compAPI.getPackageAPIs().iterator();
        while (it.hasNext()) {
            v.addAllViolations(this.genAPIViolation((PackageAPI)it.next(), compName));
        }
        return v;
    }

    private List genAPIViolation(PackageAPI pkgAPI, String compName) {
        ArrayList<ClassViolation> classViolations = new ArrayList<ClassViolation>();
        Iterator it = pkgAPI.getClassAPIs().iterator();
        while (it.hasNext()) {
            ClassViolation classViolation = this.getViolations((ClassAPI)it.next(), compName);
            if (classViolation == null) continue;
            classViolations.add(classViolation);
        }
        return classViolations;
    }

    private ClassViolation getViolations(ClassAPI classAPI, String compName) {
        boolean isSuperClassAPI;
        ClassViolation classViolation = new ClassViolation();
        classViolation.setName(classAPI.getName());
        String superClassName = classAPI.getSuperClass();
        if (superClassName != null && !(isSuperClassAPI = this.isInterface(classAPI.getAccess()) ? this.isAPI(compName, superClassName, false, false, true, false) : this.isAPI(compName, superClassName, false, true, false, false))) {
            SuperViolation superViolation = new SuperViolation();
            superViolation.setName(superClassName);
            classViolation.addViolation(superViolation);
        }
        Iterator it = classAPI.getMethodAPIs().iterator();
        while (it.hasNext()) {
            MethodAPI methodAPI = (MethodAPI)it.next();
            MethodViolation methodViolation = new MethodViolation();
            methodViolation.setName(methodAPI.getName());
            String desc = methodAPI.getDescriptor();
            String returnTypeDesc = Signature.getReturnType((String)desc);
            String returnType = this.toFullyQualifiedName(returnTypeDesc);
            if (Signature.getTypeSignatureKind((String)returnTypeDesc) != 2 && !this.isAPI(compName, returnType, true, false, false, false)) {
                ReturnViolation returnViolation = new ReturnViolation();
                returnViolation.setName(returnType);
                methodViolation.addViolation(returnViolation);
            }
            String[] params = Signature.getParameterTypes((String)desc);
            int j = 0;
            while (j < params.length) {
                String param = this.toFullyQualifiedName(params[j]);
                if (Signature.getTypeSignatureKind((String)params[j]) != 2 && !this.isAPI(compName, param, true, false, false, false)) {
                    ParamViolation paramViolation = new ParamViolation();
                    paramViolation.setName(param);
                    methodViolation.addViolation(paramViolation);
                }
                ++j;
            }
            String[] throwTypes = Signature.getThrownExceptionTypes((String)desc);
            int j2 = 0;
            while (j2 < throwTypes.length) {
                String throwType = this.toFullyQualifiedName(throwTypes[j2]);
                if (Signature.getTypeSignatureKind((String)throwTypes[j2]) != 2 && !this.isAPI(compName, throwType, true, false, false, false)) {
                    ThrowViolation throwViolation = new ThrowViolation();
                    throwViolation.setName(throwType);
                    methodViolation.addViolation(throwViolation);
                }
                ++j2;
            }
            if (methodViolation.countViolations() <= 0) continue;
            classViolation.addViolation(methodViolation);
        }
        it = classAPI.getFieldAPIs().iterator();
        while (it.hasNext()) {
            FieldAPI fieldAPI = (FieldAPI)it.next();
            String desc = new String(fieldAPI.getDescriptor());
            String field = this.toFullyQualifiedName(desc);
            if (Signature.getTypeSignatureKind((String)desc) == 2 || this.isAPI(compName, field, true, false, false, false)) continue;
            FieldViolation fieldViolation = new FieldViolation();
            fieldViolation.setName(fieldAPI.getName());
            fieldViolation.setType(field);
            classViolation.addViolation(fieldViolation);
        }
        if (classViolation.countViolations() > 0) {
            return classViolation;
        }
        return null;
    }

    private String toFullyQualifiedName(String descriptor) {
        StringBuffer sb = new StringBuffer();
        descriptor = descriptor.replace('/', '.');
        sb.append(Signature.getSignatureQualifier((String)descriptor));
        sb.append('.');
        sb.append(Signature.getSignatureSimpleName((String)descriptor).replace('.', '$'));
        return sb.toString();
    }

    private boolean isInterface(int access) {
        return (access & 0x200) == 512;
    }

    protected boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isAPI(String compName, String className, boolean ref, boolean subclass, boolean implement, boolean instantiate) {
        if (this.include(className)) {
            String pkgName = null;
            String typeName = null;
            int dot = className.lastIndexOf(46);
            if (dot != -1) {
                pkgName = className.substring(0, dot);
                typeName = className.substring(dot + 1);
                int brackets = typeName.indexOf("[]");
                if (brackets != -1) {
                    typeName = typeName.substring(0, brackets);
                }
            }
            if (pkgName != null && typeName != null) {
                Iterator it = this.pluginId2CompXML.values().iterator();
                while (it.hasNext()) {
                    ComponentXML compXML = (ComponentXML)it.next();
                    Iterator pkgIt = compXML.getPackages().iterator();
                    while (pkgIt.hasNext()) {
                        Package pkg = (Package)pkgIt.next();
                        if (!pkgName.equals(pkg.getName())) continue;
                        int index = typeName.indexOf(36);
                        String baseTypeName = index != -1 ? typeName.substring(0, index) : null;
                        Type baseType = null;
                        Iterator typeIt = pkg.getTypes().iterator();
                        while (typeIt.hasNext()) {
                            Type type = (Type)typeIt.next();
                            String name = type.getName();
                            if (typeName.equals(name)) {
                                if (ref && !type.isReference()) {
                                    return false;
                                }
                                if (subclass && !type.isSubclass() && (!compXML.getName().equals(compName) && compXML.getPlugin(compName) == null || !type.isReference())) {
                                    return false;
                                }
                                if (implement && !type.isImplement() && (!compXML.getName().equals(compName) && compXML.getPlugin(compName) == null || !type.isReference())) {
                                    return false;
                                }
                                return !instantiate || type.isInstantiate();
                            }
                            if (baseTypeName == null || baseType != null || !baseTypeName.equals(name)) continue;
                            baseType = type;
                        }
                        if (baseType != null) {
                            if (ref && !baseType.isReference()) {
                                return false;
                            }
                            if (subclass && !baseType.isSubclass()) {
                                return false;
                            }
                            if (implement && !baseType.isImplement()) {
                                return false;
                            }
                            return !instantiate || baseType.isInstantiate();
                        }
                        return pkg.isApi();
                    }
                }
            }
            return false;
        }
        return true;
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection api = (Collection)options.get("api");
        Collection outputDir = (Collection)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection refapi = (Collection)options.get("refapi");
        Collection skipAPIGen = (Collection)options.get("skipAPIGen");
        if (src == null || api == null || outputDir == null || src.size() < 1 || api.size() < 1 || outputDir.size() < 1) {
            NonAPIDependencyScanner.printUsage();
            System.exit(-1);
        }
        NonAPIDependencyScanner scanner = new NonAPIDependencyScanner();
        scanner.setSrc(src);
        scanner.setApi(api);
        scanner.setOutputDir((String)outputDir.iterator().next());
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.setRefapi(refapi);
        scanner.setSkipAPIGen(skipAPIGen != null);
        scanner.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.violation.NonAPIDependencyScanner -src <src> -api <api> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product (requires SDK build)");
        System.out.println("\t-api\t\t<api>\t\tlocation of your component.xml");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-refapi\t<refapi>\tlocation of component.xml being referenced");
        System.out.println("\t-skipAPIGen\t\t\tskip api-info.xml generation and use existing ones");
    }
}

