/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.FieldUse;
import org.eclipse.wtp.releng.tools.component.api.MethodUse;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentUse
extends ComponentAPI {
    public static final String CONST_COMPONENT_USE_XML = "component-use.xml";
    public static final String CONST_COMPONENT_USE_HTML = "component-use.html";
    private static final String ELEMENT_COMPONENT_USE = "component-use";
    private static final String ELEMENT_SOURCE = "source";
    private static final String ELEMENT_CLASS_USE = "class-use";
    private static final String ELEMENT_METHOD_USE = "method-use";
    private static final String ELEMENT_FIELD_USE = "field-use";
    private static final String ATTR_ACCESS = "access";
    private static final String ATTR_LINES = "lines";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTOR = "descriptor";
    private static final String ATTR_REFERENCE = "reference";
    private static final String ATTR_IMPLEMENT = "implement";
    private static final String ATTR_SUBCLASS = "subclass";
    private static final String ATTR_INSTANTIATE = "instantiate";
    private static final String ATTR_THROWS = "throws";
    private List sources;

    public List getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList(1);
        }
        return this.sources;
    }

    public void addSource(Source source) {
        if (this.sources == null) {
            this.sources = new ArrayList(1);
        }
        this.sources.add(source);
    }

    public void load() throws IOException, FileNotFoundException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new BufferedInputStream(this.location.getInputStream())), (DefaultHandler)new ComponentUseHandler(this));
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
        }
    }

    public void saveAsHTML(ILocation html) throws TransformerConfigurationException, TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/component-violation.xsl")));
        transformer.transform(new StreamSource(new ByteArrayInputStream(this.getBytes())), new StreamResult(new FileOutputStream(new File(html.getAbsolutePath()))));
    }

    public void save() throws IOException {
        if (this.location != null) {
            File file = new File(this.location.getAbsolutePath());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.getBytes());
            fos.close();
        }
    }

    public String toString() {
        try {
            return new String(this.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    private byte[] getBytes() throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<component-use ");
        sb.append(this.toAttribute(ATTR_NAME, this.getName()));
        sb.append(">");
        Iterator it = this.getSources().iterator();
        while (it.hasNext()) {
            this.saveSource(sb, (Source)it.next());
        }
        sb.append("</component-use>");
        return sb.toString().getBytes("UTF-8");
    }

    private void saveSource(StringBuffer sb, Source source) {
        sb.append("<source");
        sb.append(this.toAttribute(ATTR_NAME, source.getName()));
        sb.append(">");
        Iterator it = source.getClassUses().iterator();
        while (it.hasNext()) {
            this.saveClassUse(sb, (ClassUse)it.next());
        }
        sb.append("</source>");
    }

    private void saveClassUse(StringBuffer sb, ClassUse classUse) {
        Iterator it;
        int access;
        sb.append("<class-use");
        sb.append(this.toAttribute(ATTR_NAME, classUse.getName()));
        if (classUse.sizeLines() > 0) {
            sb.append(this.toAttribute(ATTR_LINES, classUse.getLines(), " "));
        }
        if ((access = classUse.getAccess()) != -1) {
            sb.append(this.toAttribute(ATTR_ACCESS, String.valueOf(access)));
        }
        if (classUse.getReference() != null) {
            sb.append(this.toAttribute(ATTR_REFERENCE, String.valueOf(classUse.isReference())));
        }
        if (classUse.getImplement() != null) {
            sb.append(this.toAttribute(ATTR_IMPLEMENT, String.valueOf(classUse.isImplement())));
        }
        if (classUse.getSubclass() != null) {
            sb.append(this.toAttribute(ATTR_SUBCLASS, String.valueOf(classUse.isSubclass())));
        }
        if (classUse.getInstantiate() != null) {
            sb.append(this.toAttribute(ATTR_INSTANTIATE, String.valueOf(classUse.isInstantiate())));
        }
        sb.append(">");
        if (classUse.sizeMethodUses() > 0) {
            it = classUse.getMethodUses().iterator();
            while (it.hasNext()) {
                this.saveMethodUse(sb, (MethodUse)it.next());
            }
        }
        if (classUse.sizeFieldUses() > 0) {
            it = classUse.getFieldUses().iterator();
            while (it.hasNext()) {
                this.saveFieldUse(sb, (FieldUse)it.next());
            }
        }
        sb.append("</class-use>");
    }

    protected void saveMethodUse(StringBuffer sb, MethodUse methodUse) {
        sb.append("<method-use");
        sb.append(this.toAttribute(ATTR_NAME, methodUse.getName()));
        sb.append(this.toAttribute(ATTR_DESCRIPTOR, methodUse.getDescriptor()));
        int access = methodUse.getAccess();
        if (access != -1) {
            sb.append(this.toAttribute(ATTR_ACCESS, String.valueOf(access)));
        }
        if (methodUse.sizeThrows() > 0) {
            sb.append(this.toAttribute(ATTR_THROWS, methodUse.getThrows(), " "));
        }
        if (methodUse.sizeLines() > 0) {
            sb.append(this.toAttribute(ATTR_LINES, methodUse.getLines(), " "));
        }
        sb.append("/>");
    }

    protected void saveFieldUse(StringBuffer sb, FieldUse fieldUse) {
        sb.append("<field-use");
        sb.append(this.toAttribute(ATTR_NAME, fieldUse.getName()));
        sb.append(this.toAttribute(ATTR_DESCRIPTOR, fieldUse.getDescriptor()));
        int access = fieldUse.getAccess();
        if (access != -1) {
            sb.append(this.toAttribute(ATTR_ACCESS, String.valueOf(access)));
        }
        if (fieldUse.sizeLines() > 0) {
            sb.append(this.toAttribute(ATTR_LINES, fieldUse.getLines(), " "));
        }
        sb.append("/>");
    }

    protected static class ComponentUseHandler
    extends ComponentAPI.ComponentAPIHandler {
        private ComponentUse compUse;
        private Source source;
        private ClassUse classUse;

        public ComponentUseHandler(ComponentUse compUse) {
            super(compUse);
            this.compUse = compUse;
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if (elementName.equals(ComponentUse.ELEMENT_SOURCE) || qName.equals(ComponentUse.ELEMENT_SOURCE)) {
                this.source = new Source();
                this.source.setName(attributes.getValue(ComponentUse.ATTR_NAME));
                this.compUse.addSource(this.source);
            } else if (elementName.equals(ComponentUse.ELEMENT_CLASS_USE) || qName.equals(ComponentUse.ELEMENT_CLASS_USE)) {
                if (this.source != null) {
                    String attrInstantiate;
                    String attrSubclass;
                    String attrImpl;
                    String attrRef;
                    String attrAccess;
                    this.classUse = new ClassUse();
                    this.classUse.setName(attributes.getValue(ComponentUse.ATTR_NAME));
                    String attrLines = attributes.getValue(ComponentUse.ATTR_LINES);
                    if (attrLines != null) {
                        this.classUse.addLines(this.toCollection(attrLines, " "));
                    }
                    if ((attrAccess = attributes.getValue(ComponentUse.ATTR_ACCESS)) != null) {
                        this.classUse.setAccess(Integer.parseInt(attrAccess));
                    }
                    if ((attrRef = attributes.getValue(ComponentUse.ATTR_REFERENCE)) != null) {
                        this.classUse.setReference(Boolean.valueOf(attrRef));
                    }
                    if ((attrImpl = attributes.getValue(ComponentUse.ATTR_IMPLEMENT)) != null) {
                        this.classUse.setImplement(Boolean.valueOf(attrImpl));
                    }
                    if ((attrSubclass = attributes.getValue(ComponentUse.ATTR_SUBCLASS)) != null) {
                        this.classUse.setSubclass(Boolean.valueOf(attrSubclass));
                    }
                    if ((attrInstantiate = attributes.getValue(ComponentUse.ATTR_INSTANTIATE)) != null) {
                        this.classUse.setInstantiate(Boolean.valueOf(attrInstantiate));
                    }
                    this.source.addClassUse(this.classUse);
                }
            } else if (elementName.equals(ComponentUse.ELEMENT_METHOD_USE) || qName.equals(ComponentUse.ELEMENT_METHOD_USE)) {
                MethodUse methodUse = new MethodUse();
                this.startMethod(this.classUse, methodUse, attributes);
                String attrLines = attributes.getValue(ComponentUse.ATTR_LINES);
                if (attrLines != null) {
                    methodUse.addLines(this.toCollection(attrLines, " "));
                }
            } else if (elementName.equals(ComponentUse.ELEMENT_FIELD_USE) || qName.equals(ComponentUse.ELEMENT_FIELD_USE)) {
                FieldUse fieldUse = new FieldUse();
                this.startField(this.classUse, fieldUse, attributes);
                String attrLines = attributes.getValue(ComponentUse.ATTR_LINES);
                if (attrLines != null) {
                    fieldUse.addLines(this.toCollection(attrLines, " "));
                }
            } else if (elementName.equals(ComponentUse.ELEMENT_COMPONENT_USE) || qName.equals(ComponentUse.ELEMENT_COMPONENT_USE)) {
                this.compUse.setName(attributes.getValue(ComponentUse.ATTR_NAME));
            }
        }
    }
}

